/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.witherform;

import java.util.UUID;
import net.kenji.kenjiscombatforms.api.powers.WitherPowers.WitherFormDashAbility;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class WitherFormDashPacket {
    private final UUID playerId;
    private final Vec3 dashDirection;
    private final double dashSpeed;

    public WitherFormDashPacket(UUID playerId, Vec3 dashDirection, double dashSpeed) {
        this.playerId = playerId;
        this.dashDirection = dashDirection;
        this.dashSpeed = dashSpeed;
    }

    public WitherFormDashPacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        this.dashDirection = new Vec3(x, y, z);
        this.dashSpeed = buf.readDouble();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.writeDouble(this.dashDirection.f_82479_);
        buf.writeDouble(this.dashDirection.f_82480_);
        buf.writeDouble(this.dashDirection.f_82481_);
        buf.writeDouble(this.dashSpeed);
    }

    public static void handle(WitherFormDashPacket packet, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                WitherFormDashPacket.handleClient(packet);
            } else {
                WitherFormDashPacket.handleServer(packet, ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }

    private static void handleClient(WitherFormDashPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        Player player = mc.f_91073_.m_46003_(packet.playerId);
        if (player != null) {
            WitherFormDashPacket.applyDashEffect(player, packet.dashDirection, packet.dashSpeed);
        }
    }

    private static void handleServer(WitherFormDashPacket packet, ServerPlayer sender) {
        if (sender != null && sender.m_20148_().equals(packet.playerId)) {
            WitherFormDashPacket.applyDashEffect((Player)sender, packet.dashDirection, packet.dashSpeed);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> sender), (Object)packet);
        }
    }

    private static void applyDashEffect(Player player, Vec3 direction, double speed) {
        WitherFormDashAbility.getInstance().activateDash(player, direction, speed);
    }
}

