/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.witherform.ability1;

import java.util.UUID;
import net.kenji.kenjiscombatforms.api.powers.WitherPowers.WitherDash;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class WitherPausePacket {
    private final UUID playerId;

    public WitherPausePacket(UUID playerId) {
        this.playerId = playerId;
    }

    public WitherPausePacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
    }

    public static void handle(WitherPausePacket packet, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                WitherPausePacket.handleClient(packet);
            } else {
                WitherPausePacket.handleServer(packet, ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }

    private static void handleClient(WitherPausePacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        Player player = mc.f_91073_.m_46003_(packet.playerId);
        if (player != null) {
            WitherPausePacket.applyDashEffect(player);
        }
    }

    private static void handleServer(WitherPausePacket packet, ServerPlayer sender) {
        if (sender != null && sender.m_20148_().equals(packet.playerId)) {
            WitherPausePacket.applyDashEffect((Player)sender);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> sender), (Object)packet);
        }
    }

    private static void applyDashEffect(Player player) {
        WitherDash.getInstance().activatePause(player);
    }
}

