/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.network.witherform.ability3;

import java.util.UUID;
import net.kenji.kenjiscombatforms.network.witherform.ClientWitherData;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncWitherData3Packet {
    private final int cooldown;
    private final boolean isWitherActive;
    private final boolean isWitherDashActive;
    private final UUID witherEntityUUID;

    public SyncWitherData3Packet(int cooldown, boolean isWitherActive, boolean isWitherDashActive, UUID witherEntityUUID) {
        this.cooldown = cooldown;
        this.isWitherActive = isWitherActive;
        this.witherEntityUUID = witherEntityUUID;
        this.isWitherDashActive = isWitherDashActive;
    }

    public SyncWitherData3Packet(FriendlyByteBuf buf) {
        this.cooldown = buf.readInt();
        this.isWitherActive = buf.readBoolean();
        this.isWitherDashActive = buf.readBoolean();
        this.witherEntityUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.cooldown);
        buf.writeBoolean(this.isWitherActive);
        buf.writeBoolean(this.isWitherDashActive);
        buf.m_130077_(this.witherEntityUUID);
    }

    public static void handle(SyncWitherData3Packet msg, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                SyncWitherData3Packet.clientSideOperations(msg);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSideOperations(SyncWitherData3Packet msg) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientWitherData.setCooldown3(msg.cooldown);
        ClientWitherData.setIsWitherActive(msg.isWitherActive);
        ClientWitherData.setIsWitherDashActive(msg.isWitherDashActive);
        if (msg.witherEntityUUID != null) {
            ClientWitherData.setWitherUUID(msg.witherEntityUUID);
        }
    }
}

