/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.kenji.kenjiscombatforms.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollFormingRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final List<Integer> counts;
    private final ItemStack output;
    private final ResourceLocation id;

    public ScrollFormingRecipe(NonNullList<Ingredient> inputItems, List<Integer> counts, ItemStack output, ResourceLocation id) {
        this.inputItems = inputItems;
        this.output = output;
        this.counts = counts;
        this.id = id;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public boolean matches(@NotNull SimpleContainer simpleContainer, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        for (int i = 0; i < this.inputItems.size(); ++i) {
            Ingredient ingredient = (Ingredient)this.inputItems.get(i);
            int requiredCount = this.counts.get(i);
            ItemStack stack = simpleContainer.m_8020_(this.getSlotForIndex(i));
            if (ingredient.test(stack) && stack.m_41613_() >= requiredCount) continue;
            return false;
        }
        return true;
    }

    private int getSlotForIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    public List<Integer> getCounts() {
        return this.counts;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer simpleContainer, @NotNull RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SCROLL_FORMING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<ScrollFormingRecipe> {
        public static Type INSTANCE = new Type();
        public static final String ID = "scroll_forming";
    }

    public static class Serializer
    implements RecipeSerializer<ScrollFormingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation resource = new ResourceLocation("kenjiscombatforms", "scroll_forming");

        @NotNull
        public ScrollFormingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject jsonObject) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (int i = 0; i < inputs.size(); ++i) {
                JsonObject ingredientJson = ingredients.get(i).getAsJsonObject();
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredientJson));
                counts.add(GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1));
            }
            return new ScrollFormingRecipe((NonNullList<Ingredient>)inputs, counts, output, pRecipeId);
        }

        @Nullable
        public ScrollFormingRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                counts.add(pBuffer.readInt());
            }
            ItemStack output = pBuffer.m_130267_();
            return new ScrollFormingRecipe((NonNullList<Ingredient>)inputs, counts, output, pRecipeId);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, @NotNull ScrollFormingRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (int i = 0; i < pRecipe.m_7527_().size(); ++i) {
                ((Ingredient)pRecipe.m_7527_().get(i)).m_43923_(pBuffer);
                pBuffer.writeInt(pRecipe.getCounts().get(i).intValue());
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }
}

