/*
 * Decompiled with CFR 0.152.
 */
package net.kenji.kenjiscombatforms.screen.form_menu;

import net.kenji.kenjiscombatforms.api.managers.FormManager;
import net.kenji.kenjiscombatforms.api.managers.client_data.ClientFistData;
import net.kenji.kenjiscombatforms.event.sound.SoundManager;
import net.kenji.kenjiscombatforms.network.NetworkHandler;
import net.kenji.kenjiscombatforms.network.fist_forms.form_swap.Form1SwapPacket;
import net.kenji.kenjiscombatforms.network.fist_forms.form_swap.Form2SwapPacket;
import net.kenji.kenjiscombatforms.network.fist_forms.form_swap.Form3SwapPacket;
import net.kenji.kenjiscombatforms.screen.form_menu.buttons.Form1SwapButton;
import net.kenji.kenjiscombatforms.screen.form_menu.buttons.Form2SwapButton;
import net.kenji.kenjiscombatforms.screen.form_menu.buttons.Form3SwapButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FormSwapMenu
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("kenjiscombatforms", "textures/gui/menus/form_swap_menu.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 256;
    int xOffset = 20;
    int yOffset = 35;
    int widgetWidth;
    int widgetHeight;
    Component basicFormButtonText = Component.m_237115_((String)"menu.kenjiscombatforms.basic_form_button");
    Component voidFormButtonText = Component.m_237115_((String)"menu.kenjiscombatforms.void_form_button");
    Component witherFormButtonText = Component.m_237115_((String)"menu.kenjiscombatforms.wither_form_button");
    private static String formToSwap;
    int form1ButtonDrawPosY;
    int form2ButtonDrawPosY;
    int form3ButtonDrawPosY;

    public FormSwapMenu(Component title) {
        super(title);
    }

    private void renderVoidLockGui(GuiGraphics guiGraphics) {
        int guiLeft = (this.f_96543_ - 256) / 2;
        int guiTop = (this.f_96544_ - 256) / 2;
        int voidFormLockOffsetX = guiLeft + this.xOffset + 24;
        int voidFormLockOffsetY = guiTop + this.yOffset + 48;
        int voidFormLockDrawPosX = 1;
        int voidFormLockDrawPosY = 101;
        guiGraphics.m_280218_(TEXTURE, voidFormLockOffsetX, voidFormLockOffsetY, voidFormLockDrawPosX, voidFormLockDrawPosY, 68, 17);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        int imageWidth = 256;
        int imageHeight = 256;
        int x = (this.f_96543_ - imageWidth) / 2;
        int y = (this.f_96544_ - imageHeight) / 2;
        this.widgetWidth = x;
        this.widgetHeight = y;
        guiGraphics.m_280218_(TEXTURE, x + this.xOffset, y + this.yOffset, 70, 0, imageWidth - 70, imageHeight + this.yOffset - 146);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6913_() {
        return true;
    }

    public boolean m_7043_() {
        return true;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null) {
            int guiLeft = (this.f_96543_ - 256) / 2;
            int guiTop = (this.f_96544_ - 256) / 2;
            int formButtonOffsetX = guiLeft + this.xOffset + 19;
            int formButtonDrawPosX = 90;
            int form1ButtonOffsetY = guiTop + this.yOffset + 47;
            int form2ButtonOffsetY = guiTop + this.yOffset + 73;
            int form3ButtonOffsetY = guiTop + this.yOffset + 99;
            String form1Text = this.getForm1Name().toLowerCase();
            String form2Text = this.getForm2Name().toLowerCase();
            String form3Text = this.getForm3Name().toLowerCase();
            MutableComponent translatedForm1Text = Component.m_237115_((String)("menu.kenjiscombatforms." + form1Text));
            MutableComponent translatedForm2Text = Component.m_237115_((String)("menu.kenjiscombatforms." + form2Text));
            MutableComponent translatedForm3Text = Component.m_237115_((String)("menu.kenjiscombatforms." + form3Text));
            if (ClientFistData.getForm1Option() != FormManager.FormSelectionOption.NONE) {
                this.form1DrawPosY();
                Form1SwapButton formButton1 = new Form1SwapButton(formButtonOffsetX, form1ButtonOffsetY, formButtonDrawPosX, this.form1ButtonDrawPosY, (Component)translatedForm1Text, button -> this.chooseForm1Option((Player)this.getMinecraft().f_91074_), 76, 20);
                this.m_142416_((GuiEventListener)formButton1);
            }
            if (ClientFistData.getForm2Option() != FormManager.FormSelectionOption.NONE) {
                this.form2DrawPosY();
                Form2SwapButton formButton2 = new Form2SwapButton(formButtonOffsetX, form2ButtonOffsetY, formButtonDrawPosX, this.form2ButtonDrawPosY, (Component)translatedForm2Text, button -> this.chooseForm2Option((Player)this.getMinecraft().f_91074_), 76, 20);
                this.m_142416_((GuiEventListener)formButton2);
            }
            if (ClientFistData.getForm3Option() != FormManager.FormSelectionOption.NONE) {
                this.form3DrawPosY();
                Form3SwapButton formButton3 = new Form3SwapButton(formButtonOffsetX, form3ButtonOffsetY, formButtonDrawPosX, this.form3ButtonDrawPosY, (Component)translatedForm3Text, button -> this.chooseForm3Option((Player)this.getMinecraft().f_91074_), 76, 20);
                this.m_142416_((GuiEventListener)formButton3);
            }
        }
    }

    private String getForm1Name() {
        if (ClientFistData.getForm1Option() != FormManager.FormSelectionOption.NONE) {
            return ClientFistData.getForm1Option().name();
        }
        return "none";
    }

    private String getForm2Name() {
        if (ClientFistData.getForm2Option() != FormManager.FormSelectionOption.NONE) {
            return ClientFistData.getForm2Option().name();
        }
        return "none";
    }

    private String getForm3Name() {
        if (ClientFistData.getForm3Option() != FormManager.FormSelectionOption.NONE) {
            return ClientFistData.getForm3Option().name();
        }
        return "none";
    }

    public static void setFormToSwap(String form) {
        formToSwap = form;
    }

    public String getFormToSwap() {
        if (formToSwap != null) {
            return formToSwap;
        }
        return "none";
    }

    private void form1DrawPosY() {
        if (ClientFistData.getForm1Option() == FormManager.FormSelectionOption.VOID) {
            this.form1ButtonDrawPosY = 151;
        }
        if (ClientFistData.getForm1Option() == FormManager.FormSelectionOption.WITHER) {
            this.form1ButtonDrawPosY = 172;
        }
        if (ClientFistData.getForm1Option() == FormManager.FormSelectionOption.SWIFT) {
            this.form1ButtonDrawPosY = 193;
        }
        if (ClientFistData.getForm1Option() == FormManager.FormSelectionOption.POWER) {
            this.form1ButtonDrawPosY = 214;
        }
    }

    private void form2DrawPosY() {
        if (ClientFistData.getForm2Option() == FormManager.FormSelectionOption.VOID) {
            this.form2ButtonDrawPosY = 151;
        }
        if (ClientFistData.getForm2Option() == FormManager.FormSelectionOption.WITHER) {
            this.form2ButtonDrawPosY = 172;
        }
        if (ClientFistData.getForm2Option() == FormManager.FormSelectionOption.SWIFT) {
            this.form2ButtonDrawPosY = 193;
        }
        if (ClientFistData.getForm2Option() == FormManager.FormSelectionOption.POWER) {
            this.form2ButtonDrawPosY = 214;
        }
    }

    private void form3DrawPosY() {
        if (ClientFistData.getForm3Option() == FormManager.FormSelectionOption.VOID) {
            this.form3ButtonDrawPosY = 151;
        }
        if (ClientFistData.getForm3Option() == FormManager.FormSelectionOption.WITHER) {
            this.form3ButtonDrawPosY = 172;
        }
        if (ClientFistData.getForm3Option() == FormManager.FormSelectionOption.SWIFT) {
            this.form3ButtonDrawPosY = 193;
        }
        if (ClientFistData.getForm3Option() == FormManager.FormSelectionOption.POWER) {
            this.form3ButtonDrawPosY = 214;
        }
    }

    private void chooseForm1Option(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new Form1SwapPacket(this.getFormToSwap()));
        if (this.f_96541_ != null && this.f_96541_.f_91080_ != null) {
            this.f_96541_.m_91152_(null);
            SoundManager.playVoidFormChooseSound(player);
        }
    }

    private void chooseForm2Option(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new Form2SwapPacket(this.getFormToSwap()));
        if (this.f_96541_ != null && this.f_96541_.f_91080_ != null) {
            this.f_96541_.m_91152_(null);
            SoundManager.playVoidFormChooseSound(player);
        }
    }

    private void chooseForm3Option(Player player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new Form3SwapPacket(this.getFormToSwap()));
        if (this.f_96541_ != null && this.f_96541_.f_91080_ != null) {
            this.f_96541_.m_91152_(null);
            SoundManager.playVoidFormChooseSound(player);
        }
    }
}

