/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.settings;

import com.google.gson.JsonObject;
import daripher.autoleveling.config.Config;
import daripher.autoleveling.settings.LevelingSettings;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public record DimensionLevelingSettings(int startingLevel, int maxLevel, float levelsPerDistance, float levelsPerDeepness, int randomLevelBonus, Optional<BlockPos> spawnPosOverride, float levelsPerDay, float levelPowerPerDistance, float levelPowerPerDeepness) implements LevelingSettings
{
    public static DimensionLevelingSettings load(JsonObject jsonObject) {
        return new DimensionLevelingSettings(jsonObject.get("starting_level").getAsInt(), jsonObject.get("max_level").getAsInt(), jsonObject.get("levels_per_distance").getAsFloat(), jsonObject.get("levels_per_deepness").getAsFloat(), jsonObject.get("random_level_bonus").getAsInt(), DimensionLevelingSettings.loadOptionalBlockPos(jsonObject, "spawn_pos_override"), DimensionLevelingSettings.readOptionalFloat(jsonObject, "levels_per_day").orElse(Float.valueOf(((Double)Config.COMMON.defaultLevelsPerDay.get()).floatValue())).floatValue(), DimensionLevelingSettings.readOptionalFloat(jsonObject, "level_power_per_distance").orElse(Float.valueOf(((Double)Config.COMMON.defaultLevelPowerPerDistance.get()).floatValue())).floatValue(), DimensionLevelingSettings.readOptionalFloat(jsonObject, "level_power_per_deepness").orElse(Float.valueOf(((Double)Config.COMMON.defaultLevelPowerPerDeepness.get()).floatValue())).floatValue());
    }

    private static Optional<Float> readOptionalFloat(JsonObject jsonObject, String name) {
        if (!jsonObject.has(name)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(jsonObject.get(name).getAsFloat()));
    }

    @NotNull
    private static Optional<BlockPos> loadOptionalBlockPos(JsonObject jsonObject, String name) {
        if (!jsonObject.has(name)) {
            return Optional.empty();
        }
        JsonObject posJson = jsonObject.get(name).getAsJsonObject();
        int x = posJson.get("x").getAsInt();
        int y = posJson.get("y").getAsInt();
        int z = posJson.get("z").getAsInt();
        return Optional.of(new BlockPos(x, y, z));
    }
}

