/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.barteringstation.world.level.block.entity.BarteringStationBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BarteringStationRenderer
implements BlockEntityRenderer<BarteringStationBlockEntity> {
    public BarteringStationRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BarteringStationBlockEntity blockEntity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        combinedLightIn = blockEntity.combinedLight;
        float ageInTicks = (float)blockEntity.time + partialTicks;
        float nextRotation = blockEntity.rot - blockEntity.oRot;
        while ((double)nextRotation >= Math.PI) {
            nextRotation = (float)((double)nextRotation - Math.PI * 2);
        }
        while ((double)nextRotation < -Math.PI) {
            nextRotation = (float)((double)nextRotation + Math.PI * 2);
        }
        float bookRotation = blockEntity.oRot + nextRotation * partialTicks;
        float bookOpen = Mth.m_14179_((float)partialTicks, (float)blockEntity.oOpen, (float)blockEntity.open);
        this.renderItem(new ItemStack((ItemLike)Items.f_42417_), ageInTicks, bookOpen, bookRotation, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, blockEntity.m_58904_());
    }

    private void renderItem(ItemStack stack, float ageInTicks, float bookOpen, float bookRotation, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Level level) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.5f, 1.03125f, 0.5f);
        matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
        bookRotation *= -57.295776f;
        bookRotation -= 90.0f;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(bookRotation *= bookOpen));
        matrixStackIn.m_85837_(0.0, (double)bookOpen, Math.sin((double)bookOpen * Math.PI));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f * (bookOpen - 1.0f)));
        float hoveringHeight = (float)Math.sin(ageInTicks * 0.06f) * bookOpen * 0.2f;
        matrixStackIn.m_252880_(0.0f, hoveringHeight, 0.0f);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, level, 0);
        matrixStackIn.m_85849_();
    }
}

