/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt;

import com.example.chunkopt.defer.LazyDecorator;
import com.example.chunkopt.gen.ChunkGenScheduler;
import com.mojang.logging.LogUtils;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="chunkopt")
public class ChunkOptEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        try {
            ChunkGenScheduler.resetCounters();
            LazyDecorator.clearQueue();
            LOGGER.info("[ChunkOpt] Server starting: counters reset and deferred queue cleared.");
        }
        catch (Throwable t) {
            LOGGER.warn("[ChunkOpt] Startup reset failed: {}", (Object)t.toString());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                LazyDecorator.runBudgeted();
            }
            catch (Throwable t) {
                LOGGER.error("[ChunkOpt] Error while draining deferred queue: {}", (Object)t.toString());
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        try {
            LazyDecorator.clearQueue();
            LOGGER.info("[ChunkOpt] Server stopping: deferred queue flushed.");
        }
        catch (Throwable t) {
            LOGGER.warn("[ChunkOpt] Shutdown flush failed: {}", (Object)t.toString());
        }
    }
}

