/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.commands;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.defer.LazyDecorator;
import com.example.chunkopt.gen.ChunkGenScheduler;
import com.example.chunkopt.util.BudgetManager;
import com.example.chunkopt.util.ChunkOptMod;
import com.example.chunkopt.util.TpsMonitor;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chunkopt")
public class ChunkOptCommands {
    private static final SuggestionProvider<CommandSourceStack> MODE_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("grid", "spiral", "random"), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chunkopt").then(Commands.m_82127_((String)"status").executes(ctx -> ChunkOptCommands.showStatus((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"stress").then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"mode", (ArgumentType)StringArgumentType.word()).suggests(MODE_SUGGESTIONS).executes(ctx -> ChunkOptCommands.runStress((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), StringArgumentType.getString((CommandContext)ctx, (String)"mode"))))))));
    }

    private static int showStatus(CommandSourceStack source) {
        double tps = TpsMonitor.getCurrentTps();
        int remainingBudget = BudgetManager.getRemainingBudget();
        int queueSize = ChunkOptMod.EXECUTOR != null ? ChunkOptMod.EXECUTOR.getQueueSize() : 0;
        int threadsActive = ChunkOptMod.EXECUTOR != null ? ChunkOptMod.EXECUTOR.getActiveCount() : 0;
        int threadsMax = (Integer)ChunkOptConfig.SERVER.maxThreads.get();
        String tpsColor = "\u00a7a";
        if (tps < (Double)ChunkOptConfig.SERVER.tpsLow.get()) {
            tpsColor = "\u00a7c";
        } else if (tps < (Double)ChunkOptConfig.SERVER.tpsTarget.get()) {
            tpsColor = "\u00a7e";
        }
        MutableComponent msg = Component.m_237113_((String)("\u00a7b[ChunkOpt Status]\n" + tpsColor + "TPS: " + String.format("%.2f", tps) + "\u00a7r\n\u00a7aRemaining budget units: \u00a7f" + remainingBudget + "\n\u00a7aExecutor queue size: \u00a7f" + queueSize + "\n\u00a7aThreads active: \u00a7f" + threadsActive + " / " + threadsMax));
        source.m_243053_((Component)msg);
        return 1;
    }

    private static int runStress(CommandSourceStack source, int radius, int count, String mode) {
        ServerLevel level = source.m_81372_();
        BlockPos blockPos = BlockPos.m_274446_((Position)source.m_81371_());
        ChunkPos center = new ChunkPos(blockPos);
        ChunkGenScheduler.resetCounters();
        LazyDecorator.setDiagnosticsActive(true);
        int peakQueue = 0;
        int durationTicks = 2000;
        source.m_243053_((Component)Component.m_237113_((String)("\u00a7b[ChunkOpt] Stress test started:\u00a7r radius=" + radius + ", duration=" + durationTicks + " ticks, pattern=" + mode + ", plans requested=" + count)));
        for (int i = 0; i < count; ++i) {
            ChunkPos pos = switch (mode.toLowerCase()) {
                case "random" -> new ChunkPos(center.f_45578_ + level.f_46441_.m_188503_(radius * 2) - radius, center.f_45579_ + level.f_46441_.m_188503_(radius * 2) - radius);
                case "spiral" -> new ChunkPos(center.f_45578_ + i % radius, center.f_45579_ + i / radius);
                case "grid" -> new ChunkPos(center.f_45578_ + i % radius, center.f_45579_ + i / radius);
                default -> center;
            };
            ChunkGenScheduler.requestPlan(level, pos);
            peakQueue = Math.max(peakQueue, ChunkOptMod.EXECUTOR.getQueueSize());
        }
        double avgTps = TpsMonitor.getCurrentTps();
        double finalTps = TpsMonitor.getCurrentTps();
        int threadsActive = ChunkOptMod.EXECUTOR.getActiveCount();
        int threadsMax = ChunkOptMod.EXECUTOR.getMaxPoolSize();
        int finalQueue = ChunkOptMod.EXECUTOR.getQueueSize();
        int remainingBudget = BudgetManager.getRemainingBudget();
        String tpsColor = "\u00a7a";
        if (finalTps < (Double)ChunkOptConfig.SERVER.tpsLow.get()) {
            tpsColor = "\u00a7c";
        } else if (finalTps < (Double)ChunkOptConfig.SERVER.tpsTarget.get()) {
            tpsColor = "\u00a7e";
        }
        MutableComponent msg = Component.m_237113_((String)("\u00a7b[ChunkOpt] Stress test complete.\u00a7r\n\u00a7aChunks requested: \u00a7f" + count + "\n\u00a7aChunks scheduled: \u00a7f" + ChunkGenScheduler.getCompletedPlans() + "\n\u00a7cFailed plans: \u00a7f" + ChunkGenScheduler.getFailedPlans() + "\n\u00a7aElapsed ticks: \u00a7f" + durationTicks + " / " + durationTicks + "\n\u00a7aPeak queue size: \u00a7f" + peakQueue + "\n\u00a7aFinal queue size: \u00a7f" + finalQueue + "\n\u00a7aRemaining budget units: \u00a7f" + remainingBudget + "\n" + tpsColor + "Average TPS: " + String.format("%.2f", avgTps) + "\u00a7r\n" + tpsColor + "Final TPS: " + String.format("%.2f", finalTps) + "\u00a7r\n\u00a7aThreads active: \u00a7f" + threadsActive + " / " + threadsMax));
        source.m_243053_((Component)msg);
        LazyDecorator.setDiagnosticsActive(false);
        return 1;
    }
}

