/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkOptConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ServerConfig SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.IntValue maxThreads;
        public final ForgeConfigSpec.IntValue maxTasksPerTick;
        public final ForgeConfigSpec.IntValue maxQueuedPlans;
        public final ForgeConfigSpec.BooleanValue adaptiveBudget;
        public final ForgeConfigSpec.DoubleValue tpsTarget;
        public final ForgeConfigSpec.DoubleValue tpsLow;
        public final ForgeConfigSpec.IntValue maxStressRadius;
        public final ForgeConfigSpec.BooleanValue diagnostics;
        public final ForgeConfigSpec.IntValue maxBudget;
        public final ForgeConfigSpec.IntValue newPlacementCost;
        public final ForgeConfigSpec.IntValue retryPlacementCost;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Performance");
            this.maxStressRadius = builder.comment("Maximum allowed radius for stress tests (in chunks)").defineInRange("maxStressRadius", 15, 1, 64);
            this.tpsTarget = builder.comment("Target TPS (usually 20.0)").defineInRange("tpsTarget", 20.0, 1.0, 20.0);
            this.tpsLow = builder.comment("Low TPS threshold to reduce budget").defineInRange("tpsLow", 18.0, 1.0, 20.0);
            this.maxThreads = builder.comment("Maximum worker threads for async chunk generation").defineInRange("maxThreads", Math.max(2, Runtime.getRuntime().availableProcessors() - 2), 1, 64);
            this.maxTasksPerTick = builder.comment("Maximum deferred decoration tasks per tick").defineInRange("maxTasksPerTick", 64, 1, 1024);
            this.maxQueuedPlans = builder.comment("Maximum queued chunk generation plans").defineInRange("maxQueuedPlans", 1024, 64, 8192);
            this.adaptiveBudget = builder.comment("Enable adaptive tick budget based on server TPS").define("adaptiveBudget", true);
            this.diagnostics = builder.comment("Enable verbose diagnostics and debug logs").define("diagnostics", false);
            builder.pop();
            builder.push("Budget");
            this.maxBudget = builder.comment("Maximum budget units available per tick for feature placement").defineInRange("maxBudget", 100, 1, 10000);
            this.newPlacementCost = builder.comment("Cost in budget units per new feature placement").defineInRange("newPlacementCost", 5, 1, 1000);
            this.retryPlacementCost = builder.comment("Cost in budget units per retry placement (0 = always allow)").defineInRange("retryPlacementCost", 1, 0, 1000);
            builder.pop();
        }
    }
}

