/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.defer;

import com.example.chunkopt.defer.DeferredExecutionModifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public record DeferredBiomeModifier(List<ResourceLocation> targets, List<String> namespaces, List<String> prefixes) implements BiomeModifier
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<DeferredBiomeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().optionalFieldOf("targets", List.of()).forGetter(DeferredBiomeModifier::targets), (App)Codec.STRING.listOf().optionalFieldOf("namespaces", List.of()).forGetter(DeferredBiomeModifier::namespaces), (App)Codec.STRING.listOf().optionalFieldOf("prefixes", List.of()).forGetter(DeferredBiomeModifier::prefixes)).apply((Applicative)instance, DeferredBiomeModifier::new));
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"chunkopt");
    public static final RegistryObject<Codec<? extends BiomeModifier>> DEFERRED = BIOME_MODIFIER_SERIALIZERS.register("deferred", () -> CODEC);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        BiomeGenerationSettingsBuilder genSettings = builder.getGenerationSettings();
        for (GenerationStep.Decoration step : GenerationStep.Decoration.values()) {
            List features = genSettings.getFeatures(step);
            for (int i = 0; i < features.size(); ++i) {
                ResourceLocation key;
                Holder holder = (Holder)features.get(i);
                Optional keyOpt = holder.m_203543_();
                if (keyOpt.isEmpty() || !this.shouldWrap(key = ((ResourceKey)keyOpt.get()).m_135782_())) continue;
                PlacedFeature placed = (PlacedFeature)holder.m_203334_();
                Holder configuredHolder = placed.f_191775_();
                List modifiers = placed.f_191776_();
                boolean alreadyWrapped = modifiers.stream().anyMatch(m -> {
                    DeferredExecutionModifier dem;
                    return m instanceof DeferredExecutionModifier && (dem = (DeferredExecutionModifier)((Object)m)).m_183327_() == DeferredExecutionModifier.DeferredPlacementTypes.DEFERRED_EXECUTION.get();
                });
                if (alreadyWrapped) continue;
                ArrayList<DeferredExecutionModifier> newModifiers = new ArrayList<DeferredExecutionModifier>(modifiers.size() + 1);
                newModifiers.add(new DeferredExecutionModifier(configuredHolder));
                newModifiers.addAll(modifiers);
                PlacedFeature wrapped = new PlacedFeature(configuredHolder, newModifiers);
                features.set(i, Holder.m_205709_((Object)wrapped));
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("[ChunkOpt] Deferred feature injected: {}", (Object)key);
            }
        }
    }

    private boolean shouldWrap(ResourceLocation key) {
        if (!this.targets.isEmpty() && this.targets.contains(key)) {
            return true;
        }
        if (!this.namespaces.isEmpty() && this.namespaces.contains(key.m_135827_())) {
            if (this.prefixes.isEmpty()) {
                return true;
            }
            String path = key.m_135815_();
            for (String p : this.prefixes) {
                if (!path.startsWith(p)) continue;
                return true;
            }
        }
        return false;
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

