/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.defer;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.defer.RetryTracker;
import com.example.chunkopt.util.BudgetManager;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class DeferredExecutionModifier
extends PlacementModifier {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Holder<ConfiguredFeature<?, ?>> configuredHolder;

    public DeferredExecutionModifier(Holder<ConfiguredFeature<?, ?>> configuredHolder) {
        this.configuredHolder = configuredHolder;
    }

    public Stream<BlockPos> m_213676_(PlacementContext ctx, RandomSource random, BlockPos origin) {
        ChunkPos chunkPos = ctx.m_191831_().m_46865_(origin).m_7697_();
        Optional<ResourceLocation> featureKeyOpt = this.configuredHolder.m_203543_().map(k -> k.m_135782_());
        Stream<BlockPos> retryStream = Stream.empty();
        if (featureKeyOpt.isPresent()) {
            List<BlockPos> retries = RetryTracker.getAndClearForFeature(chunkPos, featureKeyOpt.get());
            if (!retries.isEmpty() && ((Boolean)ChunkOptConfig.SERVER.diagnostics.get()).booleanValue()) {
                LOGGER.debug("[ChunkOpt] Retrying {} positions for feature {} in chunk {}", new Object[]{retries.size(), featureKeyOpt.get(), chunkPos});
            }
            retryStream = retries.stream();
        }
        boolean allowNew = BudgetManager.hasCapacityForNew();
        boolean allowRetry = BudgetManager.hasCapacityForRetry();
        if (!allowNew) {
            featureKeyOpt.ifPresent(key -> RetryTracker.addSkipped(chunkPos, key, origin));
            return allowRetry ? retryStream : Stream.empty();
        }
        if (((Boolean)ChunkOptConfig.SERVER.diagnostics.get()).booleanValue()) {
            LOGGER.debug("[ChunkOpt] Budget allow: {} at {}", (Object)featureKeyOpt.map(Object::toString).orElse("unknown"), (Object)origin);
        }
        return allowRetry ? Stream.concat(retryStream, Stream.of(origin)) : Stream.of(origin);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)DeferredPlacementTypes.DEFERRED_EXECUTION.get();
    }

    public static final class DeferredPlacementTypes {
        private static final Codec<DeferredExecutionModifier> CODEC = Codec.unit((Object)((Object)new DeferredExecutionModifier(Holder.m_205709_((Object)new ConfiguredFeature(Feature.f_65759_, (FeatureConfiguration)NoneFeatureConfiguration.f_67816_)))));
        public static final DeferredRegister<PlacementModifierType<?>> REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256843_, (String)"chunkopt");
        public static final RegistryObject<PlacementModifierType<DeferredExecutionModifier>> DEFERRED_EXECUTION = REGISTER.register("deferred_execution", () -> () -> CODEC);
    }
}

