/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.defer;

import com.example.chunkopt.config.ChunkOptConfig;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class FeatureRegistryHook {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new FeatureRegistryHook());
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        if (!((Boolean)ChunkOptConfig.SERVER.diagnostics.get()).booleanValue()) {
            return;
        }
        MinecraftServer server = event.getServer();
        Registry placedRegistry = server.m_206579_().m_175515_(Registries.f_256988_);
        int targeted = 0;
        for (Map.Entry entry : placedRegistry.m_6579_()) {
            ResourceLocation key = ((ResourceKey)entry.getKey()).m_135782_();
            PlacedFeature original = (PlacedFeature)entry.getValue();
            if (!this.shouldDefer(key)) continue;
            ++targeted;
            LOGGER.debug("[ChunkOpt] Would defer feature: {}", (Object)key);
        }
        LOGGER.info("[ChunkOpt] Registry scan complete. Targeted features={}", (Object)targeted);
    }

    private boolean shouldDefer(ResourceLocation key) {
        String path = key.m_135815_();
        return path.contains("tree") || path.contains("ore") || path.contains("structure");
    }
}

