/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.defer;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.model.ChunkGenPlan;
import com.example.chunkopt.util.TpsMonitor;
import com.mojang.logging.LogUtils;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class LazyDecorator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ConcurrentLinkedQueue<Runnable> deferredQueue = new ConcurrentLinkedQueue();
    private static volatile boolean diagnosticsActive = false;

    public static void setDiagnosticsActive(boolean active) {
        diagnosticsActive = active;
    }

    public static int getQueueSize() {
        return deferredQueue.size();
    }

    public static int getCurrentBudget() {
        return LazyDecorator.computeTaskBudget();
    }

    private static int computeTaskBudget() {
        int base = Math.max(1, (Integer)ChunkOptConfig.SERVER.maxTasksPerTick.get());
        if (!((Boolean)ChunkOptConfig.SERVER.adaptiveBudget.get()).booleanValue()) {
            return base;
        }
        double tps = TpsMonitor.getCurrentTps();
        double target = (Double)ChunkOptConfig.SERVER.tpsTarget.get();
        double low = (Double)ChunkOptConfig.SERVER.tpsLow.get();
        if (tps >= target) {
            return base;
        }
        if (tps <= low) {
            return Math.max(1, base / 4);
        }
        double fraction = (tps - low) / (target - low);
        return Math.max(1, (int)((double)base * fraction));
    }

    private static boolean canEnqueue() {
        int limit = Math.max(1, (Integer)ChunkOptConfig.SERVER.maxQueuedPlans.get());
        return LazyDecorator.getQueueSize() < limit;
    }

    public static void enqueue(ServerLevel level, ChunkGenPlan plan) {
        int positions = plan.deferredDecor().size();
        if (!LazyDecorator.canEnqueue()) {
            if (diagnosticsActive) {
                LOGGER.warn("[ChunkOpt] Deferred queue limit reached; rejecting {} positions for chunk ({}, {}).", new Object[]{positions, plan.getChunkX(), plan.getChunkZ()});
            }
            return;
        }
        for (BlockPos pos : plan.deferredDecor()) {
            deferredQueue.add(() -> LazyDecorator.touchChunk(level, pos));
        }
        if (diagnosticsActive) {
            LOGGER.info("[ChunkOpt] Enqueued plan for chunk ({}, {}) with {} positions. Queue={}", new Object[]{plan.getChunkX(), plan.getChunkZ(), positions, LazyDecorator.getQueueSize()});
        }
    }

    public static void enqueueTask(Runnable task) {
        if (!LazyDecorator.canEnqueue()) {
            if (diagnosticsActive) {
                LOGGER.warn("[ChunkOpt] Deferred queue limit reached; rejecting generic task. Queue={}", (Object)LazyDecorator.getQueueSize());
            }
            return;
        }
        deferredQueue.add(task);
        if (diagnosticsActive) {
            LOGGER.info("[ChunkOpt] Enqueued generic task. Queue={}", (Object)LazyDecorator.getQueueSize());
        }
    }

    private static void touchChunk(ServerLevel level, BlockPos pos) {
        if (!level.m_46805_(pos)) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        level.m_7726_().m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public static void runBudgeted() {
        Runnable task;
        int budget = LazyDecorator.computeTaskBudget();
        int processed = 0;
        int errors = 0;
        while (budget-- > 0 && (task = deferredQueue.poll()) != null) {
            try {
                task.run();
                ++processed;
            }
            catch (Throwable t) {
                ++errors;
                LOGGER.error("[ChunkOpt] Error executing deferred task.", t);
            }
        }
        if (diagnosticsActive && (processed > 0 || errors > 0)) {
            LOGGER.info("[ChunkOpt] Processed {} tasks this tick (errors={}). Queue={}", new Object[]{processed, errors, LazyDecorator.getQueueSize()});
        }
    }

    public static void clearQueue() {
        deferredQueue.clear();
        if (diagnosticsActive) {
            LOGGER.info("[ChunkOpt] Deferred queue cleared.");
        }
    }

    public static boolean hasTasks() {
        return !deferredQueue.isEmpty();
    }

    public static Runnable pollTask() {
        return deferredQueue.poll();
    }

    public static boolean isDiagnosticsActive() {
        return diagnosticsActive;
    }
}

