/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.defer;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class RetryTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ConcurrentHashMap<Long, CopyOnWriteArrayList<SkippedFeature>> skipped = new ConcurrentHashMap();

    public static void addSkipped(ChunkPos chunkPos, ResourceLocation featureKey, BlockPos pos) {
        CopyOnWriteArrayList list = skipped.computeIfAbsent(chunkPos.m_45588_(), k -> new CopyOnWriteArrayList());
        if (list.size() > 256) {
            if (list.size() == 257) {
                LOGGER.warn("[ChunkOpt] Retry list for chunk {} exceeded 256 entries; suppressing further additions.", (Object)chunkPos);
            }
            return;
        }
        list.add(new SkippedFeature(featureKey, pos));
    }

    public static List<SkippedFeature> getAndClear(ChunkPos chunkPos) {
        CopyOnWriteArrayList<SkippedFeature> removed = skipped.remove(chunkPos.m_45588_());
        return removed != null ? removed : Collections.emptyList();
    }

    public static List<BlockPos> getAndClearForFeature(ChunkPos chunkPos, ResourceLocation featureKey) {
        CopyOnWriteArrayList<SkippedFeature> list = skipped.get(chunkPos.m_45588_());
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        list.removeIf(sf -> {
            boolean match = sf.featureKey().equals((Object)featureKey);
            if (match) {
                result.add(sf.pos());
            }
            return match;
        });
        if (list.isEmpty()) {
            skipped.remove(chunkPos.m_45588_(), list);
        }
        return result;
    }

    public static boolean hasRetries() {
        return !skipped.isEmpty();
    }

    public static void clearAll() {
        skipped.clear();
        LOGGER.info("[ChunkOpt] RetryTracker cleared.");
    }

    public record SkippedFeature(ResourceLocation featureKey, BlockPos pos) {
    }
}

