/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.defer;

import com.example.chunkopt.defer.LazyDecorator;
import com.example.chunkopt.gen.ChunkGenScheduler;
import com.mojang.logging.LogUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="chunkopt")
public class TickHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (ServerLevel level : event.getServer().m_129785_()) {
                TickHandler.runBudgetedWithCounters(level);
            }
        }
    }

    private static void runBudgetedWithCounters(ServerLevel level) {
        int budget = LazyDecorator.getCurrentBudget();
        int processed = 0;
        int errors = 0;
        while (budget-- > 0 && LazyDecorator.hasTasks()) {
            Runnable task = LazyDecorator.pollTask();
            if (task == null) continue;
            try {
                task.run();
                ++processed;
                ChunkGenScheduler.incrementCompleted();
            }
            catch (Throwable t) {
                ++errors;
                ChunkGenScheduler.incrementFailed();
                LOGGER.error("[ChunkOpt] Error executing deferred task in chunk {}: {}", (Object)level.m_7726_(), (Object)t.toString());
            }
        }
        if (processed > 0 && LazyDecorator.isDiagnosticsActive()) {
            LOGGER.debug("[ChunkOpt] Processed {} tasks this tick (errors={}). Queue={}", new Object[]{processed, errors, LazyDecorator.getQueueSize()});
        }
    }
}

