/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.defer;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.util.BudgetManager;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class VanillaDecorTask
implements Runnable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PlacedFeature feature;
    private final ChunkPos targetChunk;

    public VanillaDecorTask(PlacedFeature feature, ChunkPos pos) {
        this.feature = feature;
        this.targetChunk = pos;
    }

    @Override
    public void run() {
    }

    public void execute(ServerLevel level) {
        try {
            if (!BudgetManager.hasCapacityForNew()) {
                if (((Boolean)ChunkOptConfig.SERVER.diagnostics.get()).booleanValue()) {
                    LOGGER.debug("[ChunkOpt] Skipped VanillaDecorTask for chunk ({}, {}) due to budget exhaustion.", (Object)this.targetChunk.f_45578_, (Object)this.targetChunk.f_45579_);
                }
                return;
            }
            BlockPos origin = new BlockPos(this.targetChunk.m_151390_(), level.m_141937_(), this.targetChunk.m_151393_());
            ConfiguredFeature configured = (ConfiguredFeature)this.feature.f_191775_().m_203334_();
            ChunkGenerator generator = level.m_7726_().m_8481_();
            configured.m_224953_((WorldGenLevel)level, generator, level.m_213780_(), origin);
            if (((Boolean)ChunkOptConfig.SERVER.diagnostics.get()).booleanValue()) {
                LOGGER.debug("[ChunkOpt] VanillaDecorTask executed for feature {} at chunk ({}, {})", new Object[]{this.feature.f_191775_().m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown"), this.targetChunk.f_45578_, this.targetChunk.f_45579_});
            }
        }
        catch (Exception e) {
            LOGGER.error("[ChunkOpt] Error executing VanillaDecorTask for chunk ({}, {}): {}", new Object[]{this.targetChunk.f_45578_, this.targetChunk.f_45579_, e.toString()});
        }
    }
}

