/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.gen;

import com.mojang.logging.LogUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ChunkGenExecutor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ThreadPoolExecutor executor;

    public ChunkGenExecutor(int threads) {
        ExecutorService service = Executors.newFixedThreadPool(threads, r -> {
            Thread t = new Thread(r, "ChunkOpt-Gen");
            t.setDaemon(true);
            return t;
        });
        this.executor = (ThreadPoolExecutor)service;
        LOGGER.info("[ChunkOpt] ChunkGenExecutor initialized with {} threads.", (Object)threads);
    }

    public void submit(Runnable task) {
        if (!this.executor.isShutdown()) {
            this.executor.submit(task);
        } else {
            LOGGER.warn("[ChunkOpt] Attempted to submit task after executor shutdown.");
        }
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public int getMaxPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    public int getQueueSize() {
        return this.executor.getQueue().size();
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOGGER.warn("[ChunkOpt] Executor did not terminate in time; forcing shutdown.");
                this.executor.shutdownNow();
            } else {
                LOGGER.info("[ChunkOpt] Executor shut down cleanly.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("[ChunkOpt] Shutdown interrupted; forcing shutdown.", (Throwable)e);
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }
}

