/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.gen;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.defer.LazyDecorator;
import com.example.chunkopt.model.ChunkGenPlan;
import com.example.chunkopt.util.ChunkOptMod;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class ChunkGenScheduler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicInteger completedPlans = new AtomicInteger();
    private static final AtomicInteger failedPlans = new AtomicInteger();
    private static final AtomicInteger queuedPlans = new AtomicInteger();

    public static void resetCounters() {
        completedPlans.set(0);
        failedPlans.set(0);
        queuedPlans.set(0);
        try {
            LazyDecorator.clearQueue();
            if (((Boolean)ChunkOptConfig.SERVER.diagnostics.get()).booleanValue()) {
                LOGGER.debug("[ChunkOpt] Counters reset and deferred queue cleared.");
            }
        }
        catch (Throwable t) {
            LOGGER.warn("[ChunkOpt] Counters reset; deferred queue clear failed: {}", (Object)t.toString());
        }
    }

    public static int getCompletedPlans() {
        return completedPlans.get();
    }

    public static int getFailedPlans() {
        return failedPlans.get();
    }

    public static int getQueuedPlans() {
        return queuedPlans.get();
    }

    public static void incrementCompleted() {
        completedPlans.incrementAndGet();
    }

    public static void incrementFailed() {
        failedPlans.incrementAndGet();
    }

    public static void requestPlan(ServerLevel level, ChunkPos pos) {
        if (!ChunkGenScheduler.canSubmit()) {
            ChunkGenScheduler.incrementFailed();
            LOGGER.warn("[ChunkOpt] Rejecting plan for {} due to backpressure (maxQueuedPlans={}).", (Object)pos, ChunkOptConfig.SERVER.maxQueuedPlans.get());
            return;
        }
        queuedPlans.incrementAndGet();
        ChunkOptMod.EXECUTOR.submit(() -> {
            try {
                ChunkGenPlan plan = ChunkGenScheduler.buildPlan(pos);
                level.m_7654_().execute(() -> ChunkGenScheduler.integratePlan(level, plan));
            }
            catch (Exception e) {
                ChunkGenScheduler.incrementFailed();
                LOGGER.error("[ChunkOpt] Failed to build plan for chunk {}: {}", (Object)pos, (Object)e.toString());
            }
        });
    }

    private static ChunkGenPlan buildPlan(ChunkPos pos) {
        int[] heightmap = new int[256];
        ArrayList<BlockPos> syntheticDecor = new ArrayList<BlockPos>();
        for (int i = 0; i < 16; ++i) {
            int x = pos.m_45604_() + ThreadLocalRandom.current().nextInt(16);
            int z = pos.m_45605_() + ThreadLocalRandom.current().nextInt(16);
            int y = 64 + ThreadLocalRandom.current().nextInt(32);
            syntheticDecor.add(new BlockPos(x, y, z));
        }
        return new ChunkGenPlan(pos.f_45578_, pos.f_45579_, heightmap, syntheticDecor);
    }

    private static void integratePlan(ServerLevel level, ChunkGenPlan plan) {
        try {
            LazyDecorator.enqueue(level, plan);
            ChunkGenScheduler.incrementCompleted();
            int queueSize = 0;
            try {
                queueSize = LazyDecorator.getQueueSize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (((Boolean)ChunkOptConfig.SERVER.diagnostics.get()).booleanValue()) {
                LOGGER.debug("[ChunkOpt] Integrated plan for chunk ({}, {}). Queue size={}", new Object[]{plan.getChunkX(), plan.getChunkZ(), queueSize});
            }
        }
        catch (Throwable t) {
            ChunkGenScheduler.incrementFailed();
            LOGGER.error("[ChunkOpt] Failed to integrate plan for chunk ({}, {}): {}", new Object[]{plan.getChunkX(), plan.getChunkZ(), t.toString()});
        }
    }

    private static boolean canSubmit() {
        if (ChunkOptMod.EXECUTOR == null || ChunkOptMod.EXECUTOR.isShutdown()) {
            LOGGER.warn("[ChunkOpt] Executor not ready; cannot submit plan.");
            return false;
        }
        int limit = (Integer)ChunkOptConfig.SERVER.maxQueuedPlans.get();
        int queued = ChunkOptMod.EXECUTOR.getQueueSize();
        return queued < limit;
    }
}

