/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.gen;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.gen.ChunkGenScheduler;
import com.example.chunkopt.util.BudgetManager;
import com.example.chunkopt.util.ChunkOptMod;
import com.example.chunkopt.util.TpsMonitor;
import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class ChunkStressRunner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Random RNG = new Random();

    public static void run(final CommandSourceStack source, final ServerLevel level, BlockPos center, int radius, final int duration, String pattern) {
        int maxRadius = (Integer)ChunkOptConfig.SERVER.maxStressRadius.get();
        if (radius > maxRadius) {
            String msg = "[ChunkOpt] Stress test aborted: radius exceeds maxStressRadius (" + maxRadius + ").";
            source.m_243053_((Component)Component.m_237113_((String)("\u00a7c" + msg)));
            LOGGER.info(msg);
            return;
        }
        int totalPlans = (radius * 2 + 1) * (radius * 2 + 1);
        int maxPlans = (Integer)ChunkOptConfig.SERVER.maxQueuedPlans.get();
        if (totalPlans > maxPlans) {
            String msg = "[ChunkOpt] Stress test aborted: exceeds maxQueuedPlans (" + maxPlans + ").";
            source.m_243053_((Component)Component.m_237113_((String)("\u00a7c" + msg)));
            LOGGER.info(msg);
            return;
        }
        ChunkGenScheduler.resetCounters();
        int requested = switch (pattern.toLowerCase()) {
            case "spiral" -> ChunkStressRunner.runSpiral(level, center, radius);
            case "random" -> ChunkStressRunner.runRandom(level, center, radius);
            default -> ChunkStressRunner.runGrid(level, center, radius);
        };
        String startMsg = "[ChunkOpt] Stress test started: radius=" + radius + ", duration=" + duration + " ticks, pattern=" + pattern + ", plans requested=" + requested;
        source.m_243053_((Component)Component.m_237113_((String)("\u00a7b" + startMsg)));
        LOGGER.info(startMsg);
        final int totalRequested = requested;
        final int[] peakQueue = new int[]{0};
        final double[] tpsSum = new double[]{0.0};
        final int[] tickCount = new int[]{0};
        level.m_7654_().execute(new Runnable(){
            private int ticks = 0;

            @Override
            public void run() {
                boolean timedOut;
                int quarter;
                int queueSize;
                ++this.ticks;
                tickCount[0] = tickCount[0] + 1;
                double tps = TpsMonitor.getCurrentTps();
                tpsSum[0] = tpsSum[0] + tps;
                int n = queueSize = ChunkOptMod.EXECUTOR != null ? ChunkOptMod.EXECUTOR.getQueueSize() : 0;
                if (queueSize > peakQueue[0]) {
                    peakQueue[0] = queueSize;
                }
                if (this.ticks == (quarter = Math.max(1, duration / 4)) || this.ticks == quarter * 2 || this.ticks == quarter * 3) {
                    String progressMsg = "[ChunkOpt] Stress test " + this.ticks * 100 / duration + "% complete. Elapsed ticks: " + this.ticks + " / " + duration + ", Current queue size: " + queueSize + ", Remaining budget: " + BudgetManager.getRemainingBudget();
                    source.m_243053_((Component)Component.m_237113_((String)("\u00a7b" + progressMsg)));
                    LOGGER.info(progressMsg);
                }
                boolean executorIdle = queueSize == 0;
                boolean plansDone = ChunkGenScheduler.getCompletedPlans() >= totalRequested;
                boolean bl = timedOut = this.ticks >= duration;
                if (timedOut || executorIdle && plansDone) {
                    int finalQueue = queueSize;
                    int remainingBudget = BudgetManager.getRemainingBudget();
                    double avgTps = tpsSum[0] / (double)Math.max(1, tickCount[0]);
                    int threadsActive = ChunkOptMod.EXECUTOR != null ? ChunkOptMod.EXECUTOR.getActiveCount() : 0;
                    int threadsMax = ChunkOptMod.EXECUTOR != null ? ChunkOptMod.EXECUTOR.getMaxPoolSize() : ((Integer)ChunkOptConfig.SERVER.maxThreads.get()).intValue();
                    int successPlans = ChunkGenScheduler.getCompletedPlans();
                    int failedPlans = ChunkGenScheduler.getFailedPlans();
                    String completeMsg = "[ChunkOpt] Stress test complete.\nChunks requested: " + totalRequested + "\nChunks scheduled: " + successPlans + "\nFailed plans: " + failedPlans + "\nElapsed ticks: " + this.ticks + " / " + duration + "\nPeak queue size: " + peakQueue[0] + "\nFinal queue size: " + finalQueue + "\nRemaining budget units: " + remainingBudget + "\nAverage TPS: " + String.format("%.2f", avgTps) + "\nFinal TPS: " + String.format("%.2f", tps) + "\nThreads active: " + threadsActive + " / " + threadsMax;
                    source.m_243053_((Component)Component.m_237113_((String)("\u00a7b" + completeMsg)));
                    LOGGER.info(completeMsg);
                } else {
                    level.m_7654_().execute((Runnable)this);
                }
            }
        });
    }

    private static int runGrid(ServerLevel level, BlockPos center, int radius) {
        int requested = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int chunkX = (center.m_123341_() >> 4) + dx;
                int chunkZ = (center.m_123343_() >> 4) + dz;
                ChunkGenScheduler.requestPlan(level, new ChunkPos(chunkX, chunkZ));
                ++requested;
            }
        }
        return requested;
    }

    private static int runSpiral(ServerLevel level, BlockPos center, int radius) {
        int requested = 0;
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = -1;
        int max = (radius * 2 + 1) * (radius * 2 + 1);
        for (int i = 0; i < max; ++i) {
            if (-radius <= x && x <= radius && -radius <= z && z <= radius) {
                int chunkX = (center.m_123341_() >> 4) + x;
                int chunkZ = (center.m_123343_() >> 4) + z;
                ChunkGenScheduler.requestPlan(level, new ChunkPos(chunkX, chunkZ));
                ++requested;
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                int temp = dx;
                dx = -dz;
                dz = temp;
            }
            x += dx;
            z += dz;
        }
        return requested;
    }

    private static int runRandom(ServerLevel level, BlockPos center, int radius) {
        int requested = 0;
        int total = (radius * 2 + 1) * (radius * 2 + 1);
        for (int i = 0; i < total; ++i) {
            int dx = RNG.nextInt(radius * 2 + 1) - radius;
            int dz = RNG.nextInt(radius * 2 + 1) - radius;
            int chunkX = (center.m_123341_() >> 4) + dx;
            int chunkZ = (center.m_123343_() >> 4) + dz;
            ChunkGenScheduler.requestPlan(level, new ChunkPos(chunkX, chunkZ));
            ++requested;
        }
        return requested;
    }
}

