/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.model;

import java.util.List;
import net.minecraft.core.BlockPos;

public final class ChunkGenPlan {
    private final int chunkX;
    private final int chunkZ;
    private final int[] heightmap;
    private final List<BlockPos> deferredDecor;

    public ChunkGenPlan(int chunkX, int chunkZ, int[] heightmap, List<BlockPos> deferredDecor) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.heightmap = heightmap != null ? (int[])heightmap.clone() : new int[256];
        this.deferredDecor = deferredDecor != null ? List.copyOf(deferredDecor) : List.of();
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public List<BlockPos> deferredDecor() {
        return this.deferredDecor;
    }

    public int[] getHeightmap() {
        return (int[])this.heightmap.clone();
    }

    public int getDeferredCount() {
        return this.deferredDecor.size();
    }

    public String toString() {
        return "ChunkGenPlan{chunkX=" + this.chunkX + ", chunkZ=" + this.chunkZ + ", deferredDecor=" + this.deferredDecor.size() + " positions}";
    }
}

