/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.util;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.util.TpsMonitor;
import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

public class BudgetManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static volatile int remainingBudget;

    public static void resetTickBudget() {
        int base = Math.max(0, (Integer)ChunkOptConfig.SERVER.maxBudget.get());
        if (((Boolean)ChunkOptConfig.SERVER.adaptiveBudget.get()).booleanValue()) {
            double tps = TpsMonitor.getCurrentTps();
            double target = (Double)ChunkOptConfig.SERVER.tpsTarget.get();
            double low = (Double)ChunkOptConfig.SERVER.tpsLow.get();
            if (tps >= target) {
                remainingBudget = base;
            } else if (tps <= low) {
                remainingBudget = Math.max(1, base / 4);
            } else {
                double fraction = (tps - low) / (target - low);
                remainingBudget = (int)Math.max(1.0, (double)base * fraction);
            }
            LOGGER.debug("[ChunkOpt] Adaptive budget reset: TPS={}, budget={}", (Object)String.format("%.2f", tps), (Object)remainingBudget);
        } else {
            remainingBudget = base;
            LOGGER.debug("[ChunkOpt] Static budget reset: {}", (Object)base);
        }
    }

    public static boolean hasCapacityForNew() {
        int cost = Math.max(1, (Integer)ChunkOptConfig.SERVER.newPlacementCost.get());
        return BudgetManager.consume(cost);
    }

    public static boolean hasCapacityForRetry() {
        int cost = (Integer)ChunkOptConfig.SERVER.retryPlacementCost.get();
        if (cost <= 0) {
            return true;
        }
        return BudgetManager.consume(Math.max(1, cost));
    }

    private static boolean consume(int cost) {
        if (remainingBudget >= cost) {
            remainingBudget -= cost;
            return true;
        }
        return false;
    }

    public static int getRemainingBudget() {
        return remainingBudget;
    }
}

