/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.util;

import com.example.chunkopt.config.ChunkOptConfig;
import com.example.chunkopt.defer.DeferredBiomeModifier;
import com.example.chunkopt.defer.DeferredExecutionModifier;
import com.example.chunkopt.defer.FeatureRegistryHook;
import com.example.chunkopt.defer.ModBiomeModifiers;
import com.example.chunkopt.gen.ChunkGenExecutor;
import com.example.chunkopt.util.BudgetManager;
import com.mojang.logging.LogUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="chunkopt")
public class ChunkOptMod {
    public static ChunkGenExecutor EXECUTOR;
    private static final Logger LOGGER;

    public ChunkOptMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChunkOptConfig.SERVER_SPEC);
        DeferredBiomeModifier.BIOME_MODIFIER_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        DeferredExecutionModifier.DeferredPlacementTypes.REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        FeatureRegistryHook.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        int threads = Math.max(1, (Integer)ChunkOptConfig.SERVER.maxThreads.get());
        EXECUTOR = new ChunkGenExecutor(threads);
        LOGGER.info("[ChunkOpt] Executor initialized with {} threads.", (Object)threads);
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        if (EXECUTOR != null && !EXECUTOR.isShutdown()) {
            LOGGER.info("[ChunkOpt] Shutting down executor...");
            try {
                EXECUTOR.shutdown();
            }
            catch (Throwable t) {
                LOGGER.error("[ChunkOpt] Executor shutdown error: {}", (Object)t.toString());
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            try {
                BudgetManager.resetTickBudget();
            }
            catch (Throwable t) {
                LOGGER.warn("[ChunkOpt] Budget reset failed: {}", (Object)t.toString());
            }
        }
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

