/*
 * Decompiled with CFR 0.152.
 */
package com.example.chunkopt.util;

import com.mojang.logging.LogUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class TpsMonitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static long lastTime = System.nanoTime();
    private static volatile double currentTps = 20.0;
    private static final double SMOOTHING = 0.9;

    public TpsMonitor() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long now = System.nanoTime();
            long diff = now - lastTime;
            lastTime = now;
            if (diff > 0L) {
                double tickTimeMs = (double)diff / 1000000.0;
                double instantTps = 1000.0 / tickTimeMs;
                instantTps = Math.min(instantTps, 20.0);
                currentTps = 0.9 * currentTps + 0.09999999999999998 * instantTps;
            }
        }
    }

    public static double getCurrentTps() {
        return currentTps;
    }

    public static void reset() {
        lastTime = System.nanoTime();
        currentTps = 20.0;
    }
}

