/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.blocks.kinetics.multimeter;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import uwu.lopyluna.create_dd.content.blocks.kinetics.multimeter.GaugeObservedPacket;
import uwu.lopyluna.create_dd.registry.DesiresPackets;

public class MultiMeterBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public float dialTarget;
    public int color;
    static BlockPos lastSent;

    public MultiMeterBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.STRESSOMETER, AllAdvancements.STRESSOMETER_MAXED});
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? 0.0f : (this.isOverStressed() ? 1.125f : (maxStress == 0.0f ? 0.0f : currentStress / maxStress));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? Color.mixColors((int)65280, (int)0xFFFF00, (float)(this.dialTarget * 2.0f)) : (this.dialTarget < 1.0f ? Color.mixColors((int)0xFFFF00, (int)0xFF0000, (float)(this.dialTarget * 2.0f - 1.0f)) : 0xFF0000);
        }
        this.sendData();
        this.m_6596_();
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        float speed = Math.abs(this.getSpeed());
        this.dialTarget = MultiMeterBlockEntity.getDialTarget(speed);
        this.color = Color.mixColors((int)IRotate.SpeedLevel.of((float)speed).getColor(), (int)0xFFFFFF, (float)0.25f);
        if (this.getSpeed() == 0.0f) {
            this.dialTarget = 0.0f;
            this.m_6596_();
            return;
        }
        this.m_6596_();
        this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
    }

    public static float getDialTarget(float speed) {
        speed = Math.abs(speed);
        float medium = ((Double)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Double)AllConfigs.server().kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).floatValue();
        float target = speed == 0.0f ? 0.0f : (speed < medium ? Mth.m_14179_((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? Mth.m_14179_((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : Mth.m_14179_((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f)));
        return target;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("Value", this.dialTarget);
        compound.m_128405_("Color", this.color);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.dialTarget = compound.m_128457_("Value");
        this.color = compound.m_128451_("Color");
        super.read(compound, clientPacket);
        if (clientPacket && this.f_58858_ != null && this.f_58858_.equals((Object)lastSent)) {
            lastSent = null;
        }
    }

    public void tick() {
        super.tick();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect((String)"gui.gauge.info_header", (Object[])new Object[0])));
        Lang.translate((String)"gui.speedometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (boolean)this.isOverStressed()).forGoggles(tooltip);
        double capacity = this.getNetworkCapacity();
        double stressFraction = (double)this.getNetworkStress() / (capacity == 0.0 ? 1.0 : capacity);
        Lang.translate((String)"gui.stressometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.getTheoreticalSpeed() == 0.0f) {
            Lang.text((String)TooltipHelper.makeProgressBar((int)3, (int)0)).translate("gui.stressometer.no_rotation", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        } else {
            IRotate.StressImpact.getFormattedStressText((double)stressFraction).forGoggles(tooltip);
            Lang.translate((String)"gui.stressometer.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            double remainingCapacity = capacity - (double)this.getNetworkStress();
            LangBuilder su = Lang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
            LangBuilder stressTip = Lang.number((double)remainingCapacity).add(su).style(IRotate.StressImpact.of((double)stressFraction).getRelativeColor());
            if (remainingCapacity != capacity) {
                stressTip.text(ChatFormatting.GRAY, " / ").add(Lang.number((double)capacity).add(su).style(ChatFormatting.DARK_GRAY));
            }
            stressTip.forGoggles(tooltip, 1);
        }
        if (!this.f_58858_.equals((Object)lastSent)) {
            lastSent = this.f_58858_;
            DesiresPackets.getChannel().sendToServer((Object)new GaugeObservedPacket(lastSent));
        }
        return true;
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }

    public void onObserved() {
        this.award(AllAdvancements.STRESSOMETER);
        if (Mth.m_14033_((float)this.dialTarget, (float)1.0f)) {
            this.award(AllAdvancements.STRESSOMETER_MAXED);
        }
    }
}

