/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.blocks.logistics.fluid_reservoir;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_dd.content.blocks.logistics.fluid_reservoir.FluidReservoirBlockEntity;
import uwu.lopyluna.create_dd.registry.DesiresBlockEntityTypes;

public class FluidReservoirBlock
extends Block
implements IWrenchable,
IBE<FluidReservoirBlockEntity> {
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final BooleanProperty LARGE = BooleanProperty.m_61465_((String)"large");
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final SoundType SILENCED_COPPER = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_144117_, () -> SoundEvents.f_144118_, () -> SoundEvents.f_144119_, () -> SoundEvents.f_144120_, () -> SoundEvents.f_144121_);

    public FluidReservoirBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isTank(BlockState state) {
        return state.m_60734_() instanceof FluidReservoirBlock;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, FluidReservoirBlockEntity::updateConnectivity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{TOP, BOTTOM, HORIZONTAL_AXIS, LARGE});
        super.m_7926_(p_206840_1_);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.m_43723_() != null && pContext.m_43723_().m_20161_() || (preferredAxis = FluidReservoirBlock.getKegAxis(placedOn = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_())))) == null)) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_().m_122434_().m_122478_()) {
            BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
            if (be instanceof FluidReservoirBlockEntity) {
                FluidReservoirBlockEntity keg = (FluidReservoirBlockEntity)be;
                ConnectivityHandler.splitMulti((BlockEntity)keg);
                keg.removeController(true);
            }
            state = (BlockState)state.m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        InteractionResult onWrenched = super.onWrenched(state, context);
        return onWrenched;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext == CollisionContext.m_82749_()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return pState.m_60808_(pLevel, pPos);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.DOWN && pNeighborState.m_60734_() != this) {
            this.withBlockEntityDo((BlockGetter)pLevel, pCurrentPos, FluidReservoirBlockEntity::updateConnectivity);
        }
        return pState;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        FluidReservoirBlockEntity controllerBE;
        Fluid fluid;
        ItemStack heldItem = player.m_21120_(hand);
        boolean onClient = world.f_46443_;
        if (heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        FluidHelper.FluidExchange exchange = null;
        FluidReservoirBlockEntity be = (FluidReservoirBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (be == null) {
            return InteractionResult.FAIL;
        }
        LazyOptional tankCapability = be.getCapability(ForgeCapabilities.FLUID_HANDLER);
        if (!tankCapability.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler fluidTank = (IFluidHandler)tankCapability.orElse(null);
        FluidStack prevFluidInTank = fluidTank.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((Level)world, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)world, (ItemStack)heldItem)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInTank = tankCapability.map(fh -> fh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            fluid = fluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getEmptySound((FluidStack)fluidInTank);
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getFillSound((FluidStack)prevFluidInTank);
        }
        if (soundevent != null && !onClient) {
            float pitch = Mth.m_14036_((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(FluidReservoirBlockEntity.getCapacityMultiplier() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            world.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (world.f_46441_.m_188501_() - 0.5f) / 4.0f);
        }
        if (!fluidInTank.isFluidStackIdentical(prevFluidInTank) && be instanceof FluidReservoirBlockEntity && (controllerBE = be.getControllerBE()) != null) {
            if (fluidState != null && onClient) {
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, fluidState);
                float level = (float)fluidInTank.getAmount() / (float)fluidTank.getTankCapacity(0);
                boolean reversed = fluidInTank.getFluid().getFluidType().isLighterThanAir();
                if (reversed) {
                    level = 1.0f - level;
                }
                Vec3 vec = ray.m_82450_();
                vec = new Vec3(vec.f_82479_, (double)((float)controllerBE.m_58899_().m_123342_() + level * ((float)controllerBE.height - 0.5f) + 0.25f), vec.f_82481_);
                Vec3 motion = player.m_20182_().m_82546_(vec).m_82490_((double)0.05f);
                vec = vec.m_82549_(motion);
                world.m_7106_((ParticleOptions)blockParticleData, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                return InteractionResult.SUCCESS;
            }
            controllerBE.sendDataImmediately();
            controllerBE.m_6596_();
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean pIsMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof FluidReservoirBlockEntity)) {
                return;
            }
            FluidReservoirBlockEntity kegBE = (FluidReservoirBlockEntity)be;
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)kegBE);
        }
    }

    public Class<FluidReservoirBlockEntity> getBlockEntityClass() {
        return FluidReservoirBlockEntity.class;
    }

    public BlockEntityType<? extends FluidReservoirBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DesiresBlockEntityTypes.FLUID_RESERVOIR.get();
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)rot.m_55954_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_());
    }

    @Nullable
    public static Direction.Axis getKegAxis(BlockState state) {
        if (!FluidReservoirBlock.isTank(state)) {
            return null;
        }
        return (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean isLarge(BlockState state) {
        if (!FluidReservoirBlock.isTank(state)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)LARGE);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_COPPER;
        }
        return soundType;
    }

    public boolean m_7278_(@NotNull BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return this.getBlockEntityOptional((BlockGetter)pLevel, pPos).map(FluidReservoirBlockEntity::getControllerBE).map(be -> ComparatorUtil.fractionToRedstoneLevel((double)be.getFillState())).orElse(0);
    }
}

