/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.items.equipment.deforester_saw;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_dd.content.items.equipment.BackTankAxeItem;
import uwu.lopyluna.create_dd.content.items.equipment.deforester_saw.DeforesterSawRenderer;
import uwu.lopyluna.create_dd.registry.DesireTiers;
import uwu.lopyluna.create_dd.registry.DesiresItems;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DeforesterSawItem
extends BackTankAxeItem {
    private static boolean deforesting = false;

    public DeforesterSawItem(Item.Properties pProperties) {
        super(DesireTiers.Deforester, 6.0f, -3.2f, pProperties);
    }

    public static void destroyTree(Level pLevel, BlockState state, BlockPos pos, Player player) {
        boolean playerHeldShift = player.m_6144_();
        if (deforesting || !state.m_204336_(BlockTags.f_13106_) && !AllTags.AllBlockTags.SLIMY_LOGS.matches(state) || !playerHeldShift) {
            return;
        }
        Vec3 vec = player.m_20154_();
        deforesting = true;
        TreeCutter.findTree((BlockGetter)pLevel, (BlockPos)pos).destroyBlocks(pLevel, (LivingEntity)player, (dropPos, item) -> DeforesterSawItem.dropItemFromCutTree(pLevel, pos, vec, dropPos, item));
        deforesting = false;
    }

    @SubscribeEvent
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        ItemStack heldItemMainhand = event.getPlayer().m_21120_(InteractionHand.MAIN_HAND);
        if (!DesiresItems.DEFORESTER_SAW.isIn(heldItemMainhand)) {
            return;
        }
        DeforesterSawItem.destroyTree((Level)event.getLevel(), event.getState(), event.getPos(), event.getPlayer());
    }

    public static void dropItemFromCutTree(Level world, BlockPos breakingPos, Vec3 fallDirection, BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.m_123331_((Vec3i)breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(world, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        entity.m_20256_(fallDirection.m_82490_((double)(distance / 16.0f)));
        world.m_7967_((Entity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new DeforesterSawRenderer()));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)DeforesterSawItem.maxUses());
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)DeforesterSawItem.maxUses());
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)DeforesterSawItem.maxUses());
    }

    public static int maxUses() {
        return DesireTiers.Deforester.m_6609_();
    }
}

