/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.registry;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingTypeRegistry;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import uwu.lopyluna.create_dd.DesiresCreate;
import uwu.lopyluna.create_dd.content.entities.inert_blazeling.InertBlaze;
import uwu.lopyluna.create_dd.content.entities.seething_ablaze.SeethingBlaze;
import uwu.lopyluna.create_dd.content.recipes.FreezingRecipe;
import uwu.lopyluna.create_dd.content.recipes.SandingRecipe;
import uwu.lopyluna.create_dd.content.recipes.SeethingRecipe;
import uwu.lopyluna.create_dd.registry.DesiresEntityTypes;
import uwu.lopyluna.create_dd.registry.DesiresRecipeTypes;
import uwu.lopyluna.create_dd.registry.DesiresTags;

public class DesireFanProcessingTypes {
    public static final SandingType SANDING = DesireFanProcessingTypes.register("sanding", new SandingType());
    public static final FreezingType FREEZING = DesireFanProcessingTypes.register("freezing", new FreezingType());
    public static final SeethingType SEETHING = DesireFanProcessingTypes.register("seething", new SeethingType());

    private static <T extends FanProcessingType> T register(String id, T type) {
        FanProcessingTypeRegistry.register((ResourceLocation)DesiresCreate.asResource(id), type);
        return type;
    }

    public static void register() {
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"SANDING", (Object)SANDING);
        map.put((Object)"FREEZING", (Object)FREEZING);
        map.put((Object)"SEETHING", (Object)SEETHING);
        map.trim();
    }

    public static class SandingType
    implements FanProcessingType {
        private static final SandingRecipe.SandingWrapper SANDING_WRAPPER = new SandingRecipe.SandingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (DesiresTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SANDING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return DesiresTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SANDING.matches(blockState);
        }

        public int getPriority() {
            return 691000;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            SANDING_WRAPPER.m_6836_(0, stack);
            Optional recipe = DesiresRecipeTypes.SANDING.find(SANDING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SANDING_WRAPPER.m_6836_(0, stack);
            Optional<SandingRecipe> recipe = DesiresRecipeTypes.SANDING.find(SANDING_WRAPPER, level);
            return recipe.map(sandingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)sandingRecipe)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color1 = new Color(15592395).asVectorF();
            Vector3f color2 = new Color(15197371).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color1, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)new DustParticleOptions(color2, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)new DustParticleOptions(color1, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)15197371, (int)15592395, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123797_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123790_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            CompoundTag serializeNBT;
            int progress;
            if (entity instanceof Blaze) {
                Blaze blaze = (Blaze)entity;
                if (!(entity instanceof SeethingBlaze)) {
                    progress = blaze.getPersistentData().m_128451_("CreateSanding");
                    if (progress < 50) {
                        if (progress % 10 == 0) {
                            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11701_, SoundSource.NEUTRAL, 0.5f, 1.5f * (float)progress / 50.0f);
                        }
                        blaze.getPersistentData().m_128405_("CreateSanding", progress + 1);
                        return;
                    }
                    level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11702_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                    InertBlaze inertBlaze = (InertBlaze)DesiresEntityTypes.INERT_BLAZELING.create(level);
                    serializeNBT = blaze.m_20240_(new CompoundTag());
                    serializeNBT.m_128473_("UUID");
                    assert (inertBlaze != null);
                    inertBlaze.deserializeNBT(serializeNBT);
                    inertBlaze.m_146884_(blaze.m_20318_(0.0f));
                    level.m_7967_((Entity)inertBlaze);
                    blaze.m_146870_();
                }
            }
            if (entity instanceof Zombie) {
                Zombie zombie = (Zombie)entity;
                if (!(entity instanceof Husk)) {
                    progress = zombie.getPersistentData().m_128451_("CreateSanding");
                    if (progress < 50) {
                        if (progress % 10 == 0) {
                            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12043_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                        }
                        zombie.getPersistentData().m_128405_("CreateSanding", progress + 1);
                        return;
                    }
                    level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12044_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                    Husk husk = (Husk)EntityType.f_20458_.m_20615_(level);
                    serializeNBT = zombie.m_20240_(new CompoundTag());
                    serializeNBT.m_128473_("UUID");
                    assert (husk != null);
                    husk.deserializeNBT(serializeNBT);
                    husk.m_146884_(zombie.m_20318_(0.0f));
                    level.m_7967_((Entity)husk);
                    zombie.m_146870_();
                }
            }
        }
    }

    public static class FreezingType
    implements FanProcessingType {
        private static final FreezingRecipe.FreezingWrapper FREEZING_WRAPPER = new FreezingRecipe.FreezingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (DesiresTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return DesiresTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(blockState);
        }

        public int getPriority() {
            return 691100;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional recipe = DesiresRecipeTypes.FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional<FreezingRecipe> recipe = DesiresRecipeTypes.FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.map(freezingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)freezingRecipe)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(14543103).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0xEEEEFF, (int)14543103, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_175821_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123759_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                if (entity instanceof Skeleton) {
                    Vec3 p = entity.m_20318_(0.0f);
                    Vec3 v = p.m_82520_(0.0, 0.5, 0.0).m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, (double)0.2f, 1.0).m_82541_().m_82490_(1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, (double)0.1f, 0.0);
                    if (level.f_46441_.m_188503_(3) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)0.1f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof EnderMan || entity.m_6095_() == EntityType.f_20551_) {
                entity.m_6469_(level.m_269111_().m_269109_(), 8.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 7, false, false));
            }
            if (entity instanceof SnowGolem) {
                SnowGolem snowgolem = (SnowGolem)entity;
                snowgolem.m_5634_(4.0f);
            }
            if (entity instanceof Stray) {
                Stray stray = (Stray)entity;
                stray.m_5634_(2.0f);
            }
            if (entity.m_6060_()) {
                entity.m_20095_();
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
            }
            if (entity instanceof Skeleton) {
                Skeleton skeleton = (Skeleton)entity;
                int progress = skeleton.getPersistentData().m_128451_("CreateFreezing");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12451_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                    }
                    skeleton.getPersistentData().m_128405_("CreateFreezing", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_144211_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                Stray stray = (Stray)EntityType.f_20481_.m_20615_(level);
                CompoundTag serializeNBT = skeleton.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                assert (stray != null);
                stray.deserializeNBT(serializeNBT);
                stray.m_146884_(skeleton.m_20318_(0.0f));
                level.m_7967_((Entity)stray);
                skeleton.m_146870_();
            }
        }
    }

    public static class SeethingType
    implements FanProcessingType {
        private static final SeethingRecipe.SeethingWrapper SEETHING_WRAPPER = new SeethingRecipe.SeethingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (DesiresTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SEETHING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            if (DesiresTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SEETHING.matches(blockState)) {
                return !blockState.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
            return false;
        }

        public int getPriority() {
            return 691200;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            SEETHING_WRAPPER.m_6836_(0, stack);
            Optional recipe = DesiresRecipeTypes.SEETHING.find(SEETHING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SEETHING_WRAPPER.m_6836_(0, stack);
            Optional<SeethingRecipe> recipe = DesiresRecipeTypes.SEETHING.find(SEETHING_WRAPPER, level);
            return recipe.map(seethingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)seethingRecipe)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(1969981).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + (double)0.45f, pos.f_82481_, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)6605309, (int)4158696, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123745_, 0.125f);
            }
            Vector3f colorBright = new Color(6605309).asVectorF();
            Vector3f colorDark = new Color(4158696).asVectorF();
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorBright, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorDark, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.020833334f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123762_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(192.0f, 122.0f, 85.0f, 0.075f, 10, true), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(191.0f, 82.0f, 91.0f, 0.1f, 10, true), 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            Blaze blaze;
            if (level.f_46443_) {
                return;
            }
            if (entity instanceof Blaze) {
                blaze = (Blaze)entity;
                blaze.m_5634_(4.0f);
            }
            if (!entity.m_5825_()) {
                entity.m_20254_(10);
                entity.m_6469_(level.m_269111_().m_269233_(), 10.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false));
            }
            if (entity instanceof Blaze) {
                blaze = (Blaze)entity;
                if (!(entity instanceof SeethingBlaze)) {
                    int progress = blaze.getPersistentData().m_128451_("CreateSanding");
                    if (progress < 100) {
                        if (progress % 10 == 0) {
                            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11701_, SoundSource.NEUTRAL, 1.5f, 0.5f * (float)progress / 100.0f);
                        }
                        blaze.getPersistentData().m_128405_("CreateSanding", progress + 1);
                        return;
                    }
                    level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11702_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                    SeethingBlaze seethingBlaze = (SeethingBlaze)DesiresEntityTypes.SEETHING_ABLAZE.create(level);
                    CompoundTag serializeNBT = blaze.m_20240_(new CompoundTag());
                    serializeNBT.m_128473_("UUID");
                    assert (seethingBlaze != null);
                    seethingBlaze.deserializeNBT(serializeNBT);
                    seethingBlaze.m_146884_(blaze.m_20318_(0.0f));
                    level.m_7967_((Entity)seethingBlaze);
                    blaze.m_146870_();
                }
            }
        }
    }
}

