/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.block;

import com.robertx22.dungeon_realm.api.CanEnterMapEvent;
import com.robertx22.dungeon_realm.api.CanStartMapEvent;
import com.robertx22.dungeon_realm.api.DungeonExileEvents;
import com.robertx22.dungeon_realm.api.OnStartMapEvent;
import com.robertx22.dungeon_realm.block_entity.MapDeviceBE;
import com.robertx22.dungeon_realm.item.DungeonItemMapData;
import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.main.DungeonEntries;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.dungeon_realm.main.DungeonWords;
import com.robertx22.dungeon_realm.structure.DungeonMapCapability;
import com.robertx22.dungeon_realm.structure.DungeonMapData;
import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.components.PlayerDataCapability;
import com.robertx22.library_of_exile.database.relic.stat.RelicStatsContainer;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.events.base.ExileEvent;
import com.robertx22.library_of_exile.utils.geometry.Circle2d;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;

public class MapDeviceBlock
extends BaseEntityBlock {
    public MapDeviceBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(10.0f).m_60955_().m_60953_(x -> 10));
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>();
        BlockEntity blockentity = (BlockEntity)pParams.m_287159_(LootContextParams.f_81462_);
        if (blockentity instanceof MapDeviceBE) {
            MapDeviceBE be = (MapDeviceBE)blockentity;
            all.add(this.m_5456_().m_7968_());
            for (int i = 0; i < be.inv.m_6643_(); ++i) {
                ItemStack s = be.inv.m_8020_(i);
                if (s.m_41619_()) continue;
                all.add(s.m_41777_());
            }
        }
        return all;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        try {
            if (pLevel.f_46443_) {
                SimpleParticleType particle = ParticleTypes.f_123771_;
                Circle2d c = new Circle2d(pPos, 1.5f);
                SimpleParticleType finalParticle = particle;
                c.doXTimes(5, x -> c.spawnParticle(pLevel, c.getRandomEdgePos(), (ParticleOptions)finalParticle));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startNewMap(Player p, ItemStack stack, MapDeviceBE be) {
        try {
            DungeonItemMapData map = (DungeonItemMapData)DungeonItemNbt.DUNGEON_MAP.loadFrom(stack);
            ChunkPos count = map.getOrSetStartPos(p.m_9236_(), stack);
            ChunkPos start = DungeonMain.MAIN_DUNGEON_STRUCTURE.getStartFromCounter(count.f_45578_, count.f_45579_);
            BlockPos pos = DungeonMain.MAIN_DUNGEON_STRUCTURE.getSpawnTeleportPos(start.m_151394_(5));
            PlayerDataCapability pdata = PlayerDataCapability.get((Player)p);
            DungeonMapData data = new DungeonMapData();
            data.item = map;
            data.x = start.f_45578_;
            data.z = start.f_45579_;
            be.pos = pos;
            be.m_6596_();
            LibMapData libdata = new LibMapData();
            libdata.relicStats = RelicStatsContainer.calculate(be.getAllValidRelicStats());
            data.bonusContents.setupOnMapStart(stack, libdata, p);
            DungeonMapCapability.get((Level)p.m_9236_()).data.data.setData(p, data, (MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, start.m_151394_(5));
            LibMapCap.get((Level)p.m_9236_()).data.setData(p, (Object)libdata, (MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, start.m_151394_(5));
            OnStartMapEvent event = new OnStartMapEvent(p, stack, start, DungeonMain.MAP);
            DungeonExileEvents.ON_START_NEW_MAP.callEvents((ExileEvent)event);
            stack.m_41774_(1);
            if (MapDeviceBlock.joinCurrentMap(p, be)) {
                p.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DungeonMain.DIMENSION_KEY)).m_7731_(pos.m_122019_(), ((MapDeviceBlock)((Object)DungeonEntries.MAP_DEVICE_BLOCK.get())).m_49966_(), 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean joinCurrentMap(Player p, MapDeviceBE be) {
        CanEnterMapEvent event = new CanEnterMapEvent(p, be);
        DungeonExileEvents.CAN_ENTER_MAP.callEvents((ExileEvent)event);
        if (!event.canEnter) {
            return false;
        }
        PlayerDataCapability pdata = PlayerDataCapability.get((Player)p);
        pdata.mapTeleports.entranceTeleportLogic(p, DungeonMain.DIMENSION_KEY, be.pos);
        return true;
    }

    public static ChestMenu inventory(int pContainerId, Inventory pPlayerInventory, Container pContainer) {
        return new ChestMenu(MenuType.f_39959_, pContainerId, pPlayerInventory, pContainer, 3);
    }

    public InteractionResult m_6227_(BlockState pState, Level world, BlockPos pPos, Player p, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity be;
        if (!world.f_46443_ && (be = world.m_7702_(pPos)) instanceof MapDeviceBE) {
            MapDeviceBE obe = (MapDeviceBE)be;
            if (MapDimensions.isMap((Level)world)) {
                if (p.m_6047_()) {
                    PlayerDataCapability.get((Player)p).mapTeleports.teleportHome(p);
                } else {
                    PlayerDataCapability.get((Player)p).mapTeleports.exitTeleportLogic(p);
                }
                return InteractionResult.SUCCESS;
            }
            ItemStack stack = p.m_21205_();
            if (stack.m_150930_((Item)DungeonEntries.RELIC_KEY.get())) {
                p.m_5893_((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> MapDeviceBlock.inventory(i, playerInventory, (Container)obe.inv), (Component)DungeonWords.RELIC_CONTAINER.get(new Object[0])));
                return InteractionResult.SUCCESS;
            }
            if (DungeonItemNbt.DUNGEON_MAP.has(stack)) {
                CanStartMapEvent event = new CanStartMapEvent(stack, p);
                DungeonExileEvents.CAN_START_MAP.callEvents((ExileEvent)event);
                if (!event.canEnter) {
                    return InteractionResult.SUCCESS;
                }
                MapDeviceBlock.startNewMap(p, stack, obe);
            } else if (obe.isActivated()) {
                MapDeviceBlock.joinCurrentMap(p, obe);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MapDeviceBE(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return new BlockEntityTicker<T>(){

            public void m_155252_(Level pLevel, BlockPos pPos, BlockState pState, T pBlockEntity) {
            }
        };
    }
}

