/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.database.data_blocks.mobs;

import com.robertx22.dungeon_realm.capability.DungeonEntityCapability;
import com.robertx22.dungeon_realm.database.boss_arena.BossArena;
import com.robertx22.dungeon_realm.database.data_blocks.mobs.MobBuilder;
import com.robertx22.dungeon_realm.database.holders.DungeonRelicStats;
import com.robertx22.dungeon_realm.main.DataBlockTags;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.database.map_data_block.MapBlockCtx;
import com.robertx22.library_of_exile.database.map_data_block.MapDataBlock;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.util.wiki.WikiEntry;
import com.robertx22.library_of_exile.utils.RandomUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class MapBossMB
extends MapDataBlock {
    public MapBossMB(String id) {
        super(id, id);
        this.tags.add(DataBlockTags.CAN_SPAWN_LEAGUE);
    }

    public void processImplementationINTERNAL(String s, BlockPos pos, Level level, CompoundTag nbt, MapBlockCtx ctx) {
        float chance;
        BossArena arena = DungeonMain.ARENA.getArena(new ChunkPos(pos));
        EntityType type = arena.getRandomBoss();
        int amount = 1;
        LibMapData data = LibMapCap.getData((Level)level, (BlockPos)pos);
        if (data != null && RandomUtils.roll((float)(chance = data.relicStats.get((RelicStat)DungeonRelicStats.INSTANCE.EXTRA_MAP_BOSS_CHANCE.get())))) {
            ++amount;
        }
        int finalAmount = amount;
        for (LivingEntity en : MobBuilder.of(type, this, x -> {
            x.amount = finalAmount;
        }).summonMobs(level, pos)) {
            DungeonEntityCapability.get((LivingEntity)en).data.isDungeonBoss = true;
            if (!(en instanceof Mob)) continue;
            Mob mob = (Mob)en;
            mob.m_21530_();
        }
    }

    public WikiEntry getWikiEntry() {
        return WikiEntry.of((String)"Spawns the map boss, 1 of these is required per every Boss Arena");
    }

    public Class<?> getClassForSerialization() {
        return MapBossMB.class;
    }
}

