/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.item.relic;

import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.item.relic.RelicAffixData;
import com.robertx22.dungeon_realm.item.relic.RelicItemData;
import com.robertx22.dungeon_realm.main.DungeonWords;
import com.robertx22.library_of_exile.database.relic.stat.ExactRelicStat;
import com.robertx22.library_of_exile.database.relic.stat.RelicMod;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.tooltip.TooltipBuilder;
import com.robertx22.library_of_exile.tooltip.TooltipItem;
import com.robertx22.library_of_exile.tooltip.order.ExileTooltipPart;
import com.robertx22.library_of_exile.tooltip.order.TooltipOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class RelicTooltip
extends TooltipItem {
    public static RelicTooltip DEFAULT = new RelicTooltip(ItemStack.f_41583_, null);
    public ItemStack stack;
    public RelicItemData data;

    public RelicTooltip(ItemStack stack, RelicItemData data) {
        super("relic");
        this.stack = stack;
        this.data = data;
    }

    public static List<Component> getTooltip(ItemStack stack) {
        RelicItemData data = (RelicItemData)DungeonItemNbt.RELIC.loadFrom(stack);
        if (data == null) {
            return Arrays.asList(new Component[0]);
        }
        TooltipBuilder b = new TooltipBuilder((TooltipItem)new RelicTooltip(stack, data));
        b.add(x -> {
            ArrayList<MutableComponent> all = new ArrayList<MutableComponent>();
            for (RelicAffixData affix : data.affixes) {
                for (RelicMod mod : affix.get().mods) {
                    ExactRelicStat ex = mod.toExact(affix.p);
                    all.add(ex.getStat().getTooltip(ex.num));
                }
            }
            return new ExileTooltipPart(TooltipOrder.FIRST, all);
        });
        b.add(x -> new ExileTooltipPart(TooltipOrder.MIDDLE, (Component[])new MutableComponent[]{data.getType().getTranslation(TranslationType.NAME).getTranslatedName(new Object[0]).m_130940_(ChatFormatting.GOLD)}));
        b.add(x -> new ExileTooltipPart(TooltipOrder.MIDDLE, (Component[])new MutableComponent[]{DungeonWords.RELIC_MAX_COUNT.get(data.getType().max_equipped).m_130940_(ChatFormatting.BLUE)}));
        b.add(x -> new ExileTooltipPart(TooltipOrder.LATE, (Component[])new MutableComponent[]{data.getRarity().getTranslation(TranslationType.NAME).getTranslatedName(new Object[0]).m_130940_(data.getRarity().base_data.color())}));
        b.add(x -> new ExileTooltipPart(TooltipOrder.LAST, Arrays.asList(DungeonWords.RELIC_ITEM_INFO.get(new Object[0]).m_130940_(ChatFormatting.BLUE), DungeonWords.RELIC_ITEM_INFO2.get(new Object[0]).m_130940_(ChatFormatting.BLUE))));
        return b.build();
    }
}

