/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.main;

import com.mojang.brigadier.CommandDispatcher;
import com.robertx22.dungeon_realm.item.relic.RelicGenerator;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.dungeon_realm.structure.DungeonMapCapability;
import com.robertx22.dungeon_realm.structure.DungeonWorldData;
import com.robertx22.library_of_exile.command_wrapper.ArgumentWrapper;
import com.robertx22.library_of_exile.command_wrapper.CommandBuilder;
import com.robertx22.library_of_exile.command_wrapper.PermWrapper;
import com.robertx22.library_of_exile.command_wrapper.PlayerWrapper;
import com.robertx22.library_of_exile.command_wrapper.RegistryWrapper;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.relic.relic_rarity.RelicRarity;
import com.robertx22.library_of_exile.database.relic.relic_type.RelicType;
import com.robertx22.library_of_exile.utils.PlayerUtil;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DungeonCommands {
    public static void init(CommandDispatcher d) {
        CommandBuilder.of((String)DungeonMain.MODID, (CommandDispatcher)d, x -> {
            x.addLiteral("wipe_world_data", PermWrapper.OP);
            x.action(e -> {
                ServerLevel world = ((CommandSourceStack)e.getSource()).m_81372_();
                DungeonMapCapability.get((Level)world).data = new DungeonWorldData();
                ((CommandSourceStack)e.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)"Dungeon realm World data wiped, you should only do this when wiping the dimension's folder too! The dimension folder is in: savefolder\\dimensions\\dungeon_realm").m_130940_(ChatFormatting.GREEN));
            });
        }, (String)"Applies an item modification to the item in player's hand.");
        CommandBuilder.of((String)DungeonMain.MODID, (CommandDispatcher)d, x -> {
            PlayerWrapper PLAYER = new PlayerWrapper();
            RegistryWrapper RARITY = new RegistryWrapper(LibDatabase.RELIC_RARITY);
            RegistryWrapper TYPE = new RegistryWrapper(LibDatabase.RELIC_TYPE);
            x.addLiteral("give", PermWrapper.OP);
            x.addLiteral("relic", PermWrapper.OP);
            x.addArg((ArgumentWrapper)PLAYER);
            x.addArg((ArgumentWrapper)RARITY);
            x.addArg((ArgumentWrapper)TYPE);
            x.action(e -> {
                Player p = (Player)PLAYER.get(e);
                String rar = (String)RARITY.get(e);
                String type = (String)TYPE.get(e);
                RelicGenerator.Settings set = new RelicGenerator.Settings();
                set.type = Optional.of((RelicType)LibDatabase.RelicTypes().get(type));
                set.rar = Optional.of((RelicRarity)LibDatabase.RelicRarities().get(rar));
                ItemStack stack = RelicGenerator.randomRelicItem(Optional.of(p), set);
                PlayerUtil.giveItem((ItemStack)stack, (Player)p);
            });
        }, (String)"");
    }
}

