/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.main;

import com.robertx22.dungeon_realm.block.CustomSpawnTpBlock;
import com.robertx22.dungeon_realm.capability.DungeonEntityCapability;
import com.robertx22.dungeon_realm.configs.DungeonConfig;
import com.robertx22.dungeon_realm.database.holders.DungeonRelicStats;
import com.robertx22.dungeon_realm.item.DungeonMapGenSettings;
import com.robertx22.dungeon_realm.item.DungeonMapItem;
import com.robertx22.dungeon_realm.item.relic.RelicGenerator;
import com.robertx22.dungeon_realm.main.DataBlockTags;
import com.robertx22.dungeon_realm.main.DungeonEntries;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.dungeon_realm.structure.DungeonMapCapability;
import com.robertx22.dungeon_realm.structure.DungeonMapData;
import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.components.LibMapDataSaver;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonBuilder;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.util.PointData;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class DungeonEvents {
    public static void init() {
        ExileEvents.GRAB_LIB_MAP_DATA.register((EventConsumer)new EventConsumer<ExileEvents.GrabLibMapData>(){

            public void accept(ExileEvents.GrabLibMapData event) {
                DungeonMain.ifMapData(event.level, event.pos).ifPresent(x -> {
                    LibMapDataSaver cap = LibMapCap.get((Level)event.level).data;
                    event.data = (LibMapData)cap.getData((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, event.pos);
                });
            }
        });
        ExileEvents.LIVING_ENTITY_TICK.register((EventConsumer)new EventConsumer<ExileEvents.OnEntityTick>(){

            public void accept(ExileEvents.OnEntityTick event) {
                LivingEntity livingEntity = event.entity;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer p = (ServerPlayer)livingEntity;
                    if (!event.entity.m_9236_().f_46443_ && p.f_19797_ % 40 == 0) {
                        DungeonMain.ifMapData(p.m_9236_(), p.m_20183_(), false).ifPresent(x -> x.updateMapCompletionRarity(p));
                    }
                }
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingDeathEvent.class, event -> {
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            LivingEntity mob = event.getEntity();
            if (MapDimensions.isMap((Level)mob.m_9236_())) {
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isDungeonBoss && MapDimensions.isMap((Level)mob.m_9236_())) {
                    mob.m_9236_().m_7731_(mob.m_20183_(), ((CustomSpawnTpBlock)((Object)((Object)DungeonEntries.REWARD_TELEPORT.get()))).m_49966_(), 3);
                    DungeonMain.REWARD_ROOM.generateManually((ServerLevel)mob.m_9236_(), mob.m_146902_());
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isDungeonMob) {
                    DungeonMain.ifMapData(mob.m_9236_(), mob.m_20183_()).ifPresent(x -> ++x.rooms.get((ChunkPos)mob.m_146902_()).mobs.done);
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isUberBoss) {
                    for (int i = 0; i < 3; ++i) {
                        mob.m_19983_(RelicGenerator.randomRelicItem(Optional.empty(), new RelicGenerator.Settings()));
                    }
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isDungeonBoss) {
                    Entity patt4994$temp;
                    mob.m_19983_(RelicGenerator.randomRelicItem(Optional.empty(), new RelicGenerator.Settings()));
                    LibMapData data = LibMapCap.getData((Level)mob.m_9236_(), (BlockPos)mob.m_20183_());
                    float chance = ((Double)DungeonConfig.get().UBER_FRAG_DROPRATE.get()).floatValue();
                    if (data != null) {
                        chance *= 1.0f + data.relicStats.get((RelicStat)DungeonRelicStats.INSTANCE.BONUS_BOSS_FRAG_CHANCE.get()) / 100.0f;
                    }
                    if (RandomUtils.roll((float)chance)) {
                        mob.m_19983_(((Item)DungeonEntries.UBER_FRAGMENT.get()).m_7968_());
                    }
                    if ((patt4994$temp = event.getSource().m_7639_()) instanceof Player) {
                        float mapchance;
                        Player p = (Player)patt4994$temp;
                        LibMapData libdata = LibMapCap.getData((Level)mob.m_9236_(), (BlockPos)mob.m_20183_());
                        if (libdata != null && RandomUtils.roll((float)(mapchance = libdata.relicStats.get(DungeonRelicStats.INSTANCE.BONUS_MAP_ITEM_FROM_BOSS_CHANCE)))) {
                            mob.m_19983_(DungeonMapItem.newRandomMapItemStack(new DungeonMapGenSettings()));
                        }
                    }
                }
            }
        });
        ExileEvents.ON_CHEST_LOOTED.register((EventConsumer)new EventConsumer<ExileEvents.OnChestLooted>(){

            public void accept(ExileEvents.OnChestLooted event) {
                if (event.player.m_9236_().f_46443_) {
                    return;
                }
                if (MapDimensions.isMap((Level)event.player.m_9236_())) {
                    DungeonMain.ifMapData(event.player.m_9236_(), event.pos).ifPresent(x -> ++x.rooms.get((ChunkPos)new ChunkPos((BlockPos)event.pos)).chests.done);
                }
            }
        });
        ExileEvents.PROCESS_CHUNK_DATA.register((EventConsumer)new EventConsumer<ExileEvents.OnProcessChunkData>(){

            public void accept(ExileEvents.OnProcessChunkData event) {
                if (event.struc.guid().equals(DungeonMain.MAIN_DUNGEON_STRUCTURE.guid())) {
                    DungeonMain.ifMapData(event.p.m_9236_(), event.cp.m_151394_(5)).ifPresent(x -> {
                        ++x.rooms.rooms.done;
                        ++x.bonusContents.processedChunks;
                        if (x.bonusContents.totalGenDungeonChunks < 1) {
                            DungeonBuilder built = DungeonMain.MAIN_DUNGEON_STRUCTURE.getMap(event.cp);
                            built.build();
                            x.rooms.rooms.total = built.builtDungeon.amount;
                            x.bonusContents.totalGenDungeonChunks = built.builtDungeon.amount;
                        }
                    });
                }
            }
        });
        ExileEvents.PROCESS_DATA_BLOCK.register((EventConsumer)new EventConsumer<ExileEvents.OnProcessMapDataBlock>(){

            public void accept(ExileEvents.OnProcessMapDataBlock event) {
                if (event.dataBlock.tags.contains(DataBlockTags.CAN_SPAWN_LEAGUE)) {
                    DungeonEvents.trySpawnLeagueMechanicIfCan(event.world, event.pos);
                }
            }
        });
    }

    public static void trySpawnLeagueMechanicIfCan(Level world, BlockPos pos) {
        if (DungeonMain.MAP.isInside((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, (ServerLevel)world, pos)) {
            DungeonMapData data = (DungeonMapData)DungeonMapCapability.get((Level)world).data.data.getData((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, pos);
            float chance = data.bonusContents.calcSpawnChance(pos);
            if (RandomUtils.roll((float)chance)) {
                data.spawnBonusMapContent(world, pos);
            }
            ChunkPos cp = new ChunkPos(pos);
            PointData point = new PointData(cp.f_45578_, cp.f_45579_);
            data.bonusContents.mechsChunks.add(point);
        }
    }
}

