/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.main;

import com.google.common.collect.Lists;
import com.robertx22.dungeon_realm.api.DungeonExileEvents;
import com.robertx22.dungeon_realm.capability.DungeonEntityCapability;
import com.robertx22.dungeon_realm.configs.DungeonConfig;
import com.robertx22.dungeon_realm.database.DungeonDatabase;
import com.robertx22.dungeon_realm.event.listeners.NeedPearlListener;
import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.item.DungeonMapGenSettings;
import com.robertx22.dungeon_realm.item.DungeonMapItem;
import com.robertx22.dungeon_realm.main.ComponentInit;
import com.robertx22.dungeon_realm.main.DungeonClient;
import com.robertx22.dungeon_realm.main.DungeonCommands;
import com.robertx22.dungeon_realm.main.DungeonEntries;
import com.robertx22.dungeon_realm.main.DungeonEvents;
import com.robertx22.dungeon_realm.main.DungeonLootTables;
import com.robertx22.dungeon_realm.main.DungeonMobValidator;
import com.robertx22.dungeon_realm.main.DungeonModConstructor;
import com.robertx22.dungeon_realm.main.DungeonWords;
import com.robertx22.dungeon_realm.structure.ArenaStructure;
import com.robertx22.dungeon_realm.structure.DungeonMapCapability;
import com.robertx22.dungeon_realm.structure.DungeonMapData;
import com.robertx22.dungeon_realm.structure.DungeonMapStructure;
import com.robertx22.dungeon_realm.structure.RewardStructure;
import com.robertx22.dungeon_realm.structure.UberArenaStructure;
import com.robertx22.library_of_exile.config.map_dimension.MapDimensionConfigDefaults;
import com.robertx22.library_of_exile.config.map_dimension.MapRegisterBuilder;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.init.PredeterminedResult;
import com.robertx22.library_of_exile.database.mob_list.MobList;
import com.robertx22.library_of_exile.dimension.MapChunkGenEvent;
import com.robertx22.library_of_exile.dimension.MapContentType;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.MobValidator;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.dimension.structure.dungeon.IDungeon;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.helpers.OrderedModConstructor;
import com.robertx22.library_of_exile.registry.register_info.ModRequiredRegisterInfo;
import com.robertx22.library_of_exile.registry.util.ExileRegistryUtil;
import com.robertx22.library_of_exile.unidentified.IdentifiableItems;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="dungeon_realm")
public class DungeonMain {
    public static boolean RUN_DEV_TOOLS = false;
    public static String MODID = "dungeon_realm";
    public static String DIMENSION_ID = "dungeon_realm:dungeon";
    public static final Logger LOG = LoggerFactory.getLogger((String)MODID);
    public static ResourceLocation DIMENSION_KEY = new ResourceLocation(DIMENSION_ID);
    public static ModRequiredRegisterInfo REGISTER_INFO = new ModRequiredRegisterInfo(MODID);
    public static DungeonMapStructure MAIN_DUNGEON_STRUCTURE = new DungeonMapStructure();
    public static ArenaStructure ARENA = new ArenaStructure();
    public static UberArenaStructure UBER_ARENA = new UberArenaStructure();
    public static RewardStructure REWARD_ROOM = new RewardStructure();
    public static MapDimensionInfo MAP = new MapDimensionInfo(DIMENSION_KEY, (MapStructure)MAIN_DUNGEON_STRUCTURE, MapContentType.PRIMARY_CONTENT, Arrays.asList(new MapStructure[]{ARENA, UBER_ARENA, REWARD_ROOM}), (MobValidator)new DungeonMobValidator(), new MapDimensionConfigDefaults(3, 1));
    public static PredeterminedResult<MobList> DUNGEON_MOB_SPAWNS = new PredeterminedResult<MobList>(){

        public ExileRegistryType getRegistryType() {
            return LibDatabase.MOB_LIST;
        }

        public MobList getPredeterminedRandomINTERNAL(Random random, Level level, ChunkPos pos) {
            IDungeon dungeon = DungeonMain.MAIN_DUNGEON_STRUCTURE.getMap((ChunkPos)pos).dungeon;
            return (MobList)LibDatabase.MobLists().getFilterWrapped(x -> dungeon.getDungeonData().mob_list_tag_check.matches((ExileRegistry)x).can).random(random.nextDouble());
        }
    };

    public static ResourceLocation id(String id) {
        return new ResourceLocation(MODID, id);
    }

    public DungeonMain() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        OrderedModConstructor.register((OrderedModConstructor)new DungeonModConstructor(MODID), (IEventBus)bus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        new MapRegisterBuilder(MAP).chunkGenerator((EventConsumer)new EventConsumer<MapChunkGenEvent>(){

            public void accept(MapChunkGenEvent event) {
                if (event.mapId.equals("dungeon")) {
                    MAIN_DUNGEON_STRUCTURE.generateInChunk((ServerLevelAccessor)event.world, event.manager, event.chunk.m_7697_());
                    ARENA.generateInChunk((ServerLevelAccessor)event.world, event.manager, event.chunk.m_7697_());
                    UBER_ARENA.generateInChunk((ServerLevelAccessor)event.world, event.manager, event.chunk.m_7697_());
                    REWARD_ROOM.generateInChunk((ServerLevelAccessor)event.world, event.manager, event.chunk.m_7697_());
                }
            }
        }, DungeonMain.id("dungeon_chunk_gen")).build();
        if (RUN_DEV_TOOLS) {
            ExileRegistryUtil.setCurrentRegistarMod((String)MODID);
            ApiForgeEvents.registerForgeEvent(PlayerEvent.PlayerLoggedInEvent.class, event -> DungeonDatabase.INSTANCE.runDataGen(CachedOutput.f_236016_));
        }
        ApiForgeEvents.registerForgeEvent(GatherDataEvent.class, event -> {
            PackOutput output = event.getGenerator().getPackOutput();
            LootTableProvider.SubProviderEntry chestsLootTables = new LootTableProvider.SubProviderEntry(DungeonLootTables.DungeonLootTableProvider::new, LootContextParamSets.f_81411_);
            LootTableProvider provider = new LootTableProvider(output, Set.of(), List.of(chestsLootTables));
            event.getGenerator().addProvider(true, (DataProvider)provider);
            try {
                event.getGenerator().m_123917_();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DungeonConfig.SPEC);
        bus.addListener(this::commonSetupEvent);
        ApiForgeEvents.registerForgeEvent(RegisterCommandsEvent.class, event -> DungeonCommands.init(event.getDispatcher()));
        DungeonEvents.init();
        DungeonExileEvents.init();
        ExileEvents.ON_CHEST_LOOTED.register((EventConsumer)new EventConsumer<ExileEvents.OnChestLooted>(){

            public void accept(ExileEvents.OnChestLooted e) {
                try {
                    List<Integer> empty;
                    float chance;
                    if (!MapDimensions.isMap((Level)e.player.m_9236_()) && RandomUtils.roll((float)(chance = (float)((Double)DungeonConfig.get().DUNGEON_MAP_SPAWN_CHANCE_ON_CHEST_LOOT.get() * (double)DungeonConfig.get().getDimChanceMulti(e.player.m_9236_())))) && !(empty = DungeonMain.mygetEmptySlotsRandomized(e.inventory, new Random())).isEmpty()) {
                        int index = (Integer)RandomUtils.randomFromList(empty);
                        ItemStack map = DungeonMapItem.newRandomMapItemStack(new DungeonMapGenSettings());
                        e.inventory.m_6836_(index, map);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        DungeonEntries.CREATIVE_TAB.register(MODID, () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 2).m_257737_(() -> ((BlockItem)DungeonEntries.MAP_DEVICE_ITEM.get()).m_7968_()).m_257941_((Component)DungeonWords.CREATIVE_TAB.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})).m_257501_(new CreativeModeTab.DisplayItemsGenerator(){

            public void m_257865_(CreativeModeTab.ItemDisplayParameters param, CreativeModeTab.Output output) {
                for (Item item : ForgeRegistries.ITEMS) {
                    if (!ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals(MODID)) continue;
                    output.m_246326_((ItemLike)item);
                }
            }
        }).m_257652_());
        IdentifiableItems.register((ResourceLocation)DungeonEntries.DUNGEON_MAP_ITEM.getId(), (IdentifiableItems.Config)new IdentifiableItems.Config(){

            public boolean isUnidentified(ItemStack stack) {
                return !DungeonItemNbt.DUNGEON_MAP.has(stack);
            }

            public void identify(Player player, ItemStack stack) {
                ItemStack newstack = DungeonMapItem.newRandomMapItemStack(new DungeonMapGenSettings());
                stack.m_41751_(newstack.m_41783_());
            }
        });
        DungeonExileEvents.CAN_ENTER_MAP.register((EventConsumer)new NeedPearlListener());
        LOG.info("Dungeon Realm loaded.");
    }

    private static List<Integer> mygetEmptySlotsRandomized(Container inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static Optional<DungeonMapData> ifMapData(Level level, BlockPos pos) {
        return DungeonMapCapability.DATA_GETTER.ifMapData(level, pos, true);
    }

    public static Optional<DungeonMapData> ifMapData(Level level, BlockPos pos, boolean grabConnectedData) {
        return DungeonMapCapability.DATA_GETTER.ifMapData(level, pos, grabConnectedData);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        DungeonClient.init();
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        ComponentInit.reg();
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, x -> x.addCapability(DungeonMapCapability.RESOURCE, (ICapabilityProvider)new DungeonMapCapability((Level)x.getObject())));
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, x -> {
            Object patt11432$temp = x.getObject();
            if (patt11432$temp instanceof LivingEntity) {
                LivingEntity en = (LivingEntity)patt11432$temp;
                x.addCapability(DungeonEntityCapability.RESOURCE, (ICapabilityProvider)new DungeonEntityCapability(en));
            }
        });
    }
}

