/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.structure;

import com.robertx22.dungeon_realm.structure.HasDoneData;
import com.robertx22.dungeon_realm.structure.SingleRoomData;
import com.robertx22.library_of_exile.main.ExileLog;
import java.util.HashMap;
import net.minecraft.world.level.ChunkPos;

public class MapRoomsData {
    public HasDoneData rooms = new HasDoneData();
    private HashMap<String, SingleRoomData> map = new HashMap();

    public void addRoom(ChunkPos cp) {
        String key = this.key(cp);
        if (!this.map.containsKey(key)) {
            this.map.put(key, new SingleRoomData());
        }
    }

    public SingleRoomData get(ChunkPos cp) {
        String key = this.key(cp);
        if (!this.map.containsKey(key)) {
            this.map.put(key, new SingleRoomData());
        }
        return this.map.get(key);
    }

    String key(ChunkPos cp) {
        String key = cp.f_45578_ + "_" + cp.f_45579_;
        return key;
    }

    public boolean isDoneGenerating() {
        if (this.rooms.total <= 0) {
            return false;
        }
        return this.rooms.done >= this.rooms.total;
    }

    public int getMapCompletePercent() {
        if (this.rooms.total < 1) {
            return 0;
        }
        int totalpercents = 0;
        for (SingleRoomData data : this.map.values()) {
            totalpercents += data.getPercentDone();
        }
        int perc = totalpercents / this.rooms.total;
        if (perc > 100) {
            perc = 100;
            ExileLog.get().log("Map progress percent is somehow more than 100!", new Object[0]);
        }
        return perc;
    }
}

