/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.database.data_blocks.chests;

import com.robertx22.dungeon_realm.main.DungeonLootTables;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.library_of_exile.database.map_data_block.MapBlockCtx;
import com.robertx22.library_of_exile.database.map_data_block.MapDataBlock;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.util.wiki.WikiEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class MapChestMB
extends MapDataBlock {
    public MapChestMB(String id) {
        super(id, id);
        this.aliases.add("big_chest");
        this.aliases.add("puzzle");
        this.aliases.add("trap_chest");
    }

    public Class<?> getClassForSerialization() {
        return MapChestMB.class;
    }

    public void processImplementationINTERNAL(String key, BlockPos pos, Level world, CompoundTag nbt, MapBlockCtx ctx) {
        boolean isTrapped = key.contains("trap");
        ResourceLocation table = DungeonLootTables.randomMapLoot();
        MapChestMB.createChest(world, pos, isTrapped, table);
        DungeonMain.ifMapData(world, pos).ifPresent(x -> {
            ++x.totalChests;
            x.updateMapLootCompletion((ServerLevel)world, pos);
        });
    }

    public static void createChest(Level world, BlockPos pos, boolean trapped, ResourceLocation table) {
        if (trapped) {
            world.m_7731_(pos, Blocks.f_50325_.m_49966_(), 2);
        } else {
            world.m_7731_(pos, Blocks.f_50087_.m_49966_(), 2);
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            ChestBlockEntity.m_222766_((BlockGetter)world, (RandomSource)world.m_213780_(), (BlockPos)pos, (ResourceLocation)table);
        } else {
            ExileLog.get().warn("Chest gen failed, tile not instanceof vanilla chest.", new Object[0]);
        }
    }

    public WikiEntry getWikiEntry() {
        return WikiEntry.of((String)"Always spawns a chest");
    }
}

