/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.dungeons_arise.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class ModifiedJigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext p_227239_, Holder<StructureTemplatePool> p_227240_, Optional<ResourceLocation> p_227241_, int p_227242_, BlockPos p_227243_, boolean p_227244_, Optional<Heightmap.Types> p_227245_, int p_227246_) {
        BlockPos blockpos;
        RegistryAccess registryaccess = p_227239_.f_226621_();
        ChunkGenerator chunkgenerator = p_227239_.f_226622_();
        StructureTemplateManager structuretemplatemanager = p_227239_.f_226625_();
        LevelHeightAccessor levelheightaccessor = p_227239_.f_226629_();
        WorldgenRandom worldgenrandom = p_227239_.f_226626_();
        Registry registry = registryaccess.m_175515_(Registries.f_256948_);
        Rotation rotation = Rotation.NONE;
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)p_227240_.m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_227355_((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (p_227241_.isPresent()) {
            ResourceLocation resourcelocation = p_227241_.get();
            Optional<BlockPos> optional = ModifiedJigsawPlacement.getRandomNamedJigsaw(structurepoolelement, resourcelocation, p_227243_, rotation, structuretemplatemanager, worldgenrandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)p_227240_.m_203543_().map(p_248484_ -> p_248484_.m_135782_().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockpos = optional.get();
        } else {
            blockpos = p_227243_;
        }
        BlockPos vec3i = blockpos.m_121996_((Vec3i)p_227243_);
        BlockPos blockpos1 = p_227243_.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_214015_(structuretemplatemanager, blockpos1, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = p_227245_.isPresent() ? p_227243_.m_123342_() + chunkgenerator.m_223221_(i, j, p_227245_.get(), levelheightaccessor, p_227239_.f_226624_()) : blockpos1.m_123342_();
        int bX = Math.abs(boundingbox.m_71056_() / 2);
        int bZ = Math.abs(boundingbox.m_71058_() / 2);
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(-bX, k - l, -bZ);
        int i1 = k + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), p_227237_ -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (p_227242_ > 0) {
                AABB aabb = new AABB((double)(i - p_227246_), (double)(i1 - p_227246_), (double)(j - p_227246_), (double)(i + p_227246_ + 1), (double)(i1 + p_227246_ + 1), (double)(j + p_227246_ + 1));
                VoxelShape voxelshape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_);
                ModifiedJigsawPlacement.addPieces(p_227239_.f_226624_(), p_227242_, p_227244_, chunkgenerator, structuretemplatemanager, levelheightaccessor, (RandomSource)worldgenrandom, (Registry<StructureTemplatePool>)registry, poolelementstructurepiece, list, voxelshape);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_227237_).m_142679_(arg_0));
            }
        }));
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement p_227248_, ResourceLocation p_227249_, BlockPos p_227250_, Rotation p_227251_, StructureTemplateManager p_227252_, WorldgenRandom p_227253_) {
        List list = p_227248_.m_213638_(p_227252_, p_227250_, p_227251_, (RandomSource)p_227253_);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : list) {
            ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)structuretemplate$structureblockinfo.f_74677_().m_128461_("name"));
            if (!p_227249_.equals((Object)resourcelocation)) continue;
            optional = Optional.of(structuretemplate$structureblockinfo.f_74675_());
            break;
        }
        return optional;
    }

    private static void addPieces(RandomState p_227211_, int p_227212_, boolean p_227213_, ChunkGenerator p_227214_, StructureTemplateManager p_227215_, LevelHeightAccessor p_227216_, RandomSource p_227217_, Registry<StructureTemplatePool> p_227218_, PoolElementStructurePiece p_227219_, List<PoolElementStructurePiece> p_227220_, VoxelShape p_227221_) {
        Placer jigsawplacement$placer = new Placer(p_227218_, p_227212_, p_227214_, p_227215_, p_227220_, p_227217_);
        jigsawplacement$placer.placing.addLast(new PieceState(p_227219_, (MutableObject<VoxelShape>)new MutableObject((Object)p_227221_), 0));
        while (!jigsawplacement$placer.placing.isEmpty()) {
            PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
            jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, p_227213_, p_227216_, p_227211_);
        }
    }

    public static boolean generateJigsaw(ServerLevel p_227204_, Holder<StructureTemplatePool> p_227205_, ResourceLocation p_227206_, int p_227207_, BlockPos p_227208_, boolean p_227209_) {
        ChunkGenerator chunkgenerator = p_227204_.m_7726_().m_8481_();
        StructureTemplateManager structuretemplatemanager = p_227204_.m_215082_();
        StructureManager structuremanager = p_227204_.m_215010_();
        RandomSource randomsource = p_227204_.m_213780_();
        Structure.GenerationContext structure$generationcontext = new Structure.GenerationContext(p_227204_.m_9598_(), chunkgenerator, chunkgenerator.m_62218_(), p_227204_.m_7726_().m_214994_(), structuretemplatemanager, p_227204_.m_7328_(), new ChunkPos(p_227208_), (LevelHeightAccessor)p_227204_, p_227255_ -> true);
        Optional<Structure.GenerationStub> optional = ModifiedJigsawPlacement.addPieces(structure$generationcontext, p_227205_, Optional.of(p_227206_), p_227207_, p_227208_, false, Optional.empty(), 128);
        if (optional.isPresent()) {
            StructurePiecesBuilder structurepiecesbuilder = optional.get().m_226677_();
            for (StructurePiece structurepiece : structurepiecesbuilder.m_192780_().f_192741_()) {
                if (!(structurepiece instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece poolelementstructurepiece = (PoolElementStructurePiece)structurepiece;
                poolelementstructurepiece.m_226509_((WorldGenLevel)p_227204_, structuremanager, chunkgenerator, randomsource, BoundingBox.m_71044_(), p_227208_, p_227209_);
            }
            return true;
        }
        return false;
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> p_227258_, int p_227259_, ChunkGenerator p_227260_, StructureTemplateManager p_227261_, List<? super PoolElementStructurePiece> p_227262_, RandomSource p_227263_) {
            this.pools = p_227258_;
            this.maxDepth = p_227259_;
            this.chunkGenerator = p_227260_;
            this.structureTemplateManager = p_227261_;
            this.pieces = p_227262_;
            this.random = p_227263_;
        }

        void tryPlacingChildren(PoolElementStructurePiece p_227265_, MutableObject<VoxelShape> p_227266_, int p_227267_, boolean p_227268_, LevelHeightAccessor p_227269_, RandomState p_227270_) {
            StructurePoolElement structurepoolelement = p_227265_.m_209918_();
            BlockPos blockpos = p_227265_.m_72646_();
            Rotation rotation = p_227265_.m_6830_();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.m_210539_();
            boolean flag = structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = p_227265_.m_73547_();
            int i = boundingbox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : structurepoolelement.m_213638_(this.structureTemplateManager, blockpos, rotation, this.random)) {
                StructurePoolElement structurepoolelement1;
                MutableObject<VoxelShape> mutableobject1;
                Direction direction = JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_());
                BlockPos blockpos1 = structuretemplate$structureblockinfo.f_74675_();
                BlockPos blockpos2 = blockpos1.m_121945_(direction);
                int j = blockpos1.m_123342_() - i;
                int k = -1;
                ResourceKey<StructureTemplatePool> resourcekey = Placer.readPoolName(structuretemplate$structureblockinfo);
                Optional optional = this.pools.m_203636_(resourcekey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.m_135782_());
                    continue;
                }
                Holder holder = (Holder)optional.get();
                if (((StructureTemplatePool)holder.m_203334_()).m_210590_() == 0 && !holder.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.m_135782_());
                    continue;
                }
                Holder holder1 = ((StructureTemplatePool)holder.m_203334_()).m_254935_();
                if (((StructureTemplatePool)holder1.m_203334_()).m_210590_() == 0 && !holder1.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)holder1.m_203543_().map(p_255599_ -> p_255599_.m_135782_().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean flag1 = boundingbox.m_71051_((Vec3i)blockpos2);
                if (flag1) {
                    mutableobject1 = mutableobject;
                    if (mutableobject.getValue() == null) {
                        mutableobject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)));
                    }
                } else {
                    mutableobject1 = p_227266_;
                }
                ArrayList list = Lists.newArrayList();
                if (p_227267_ != this.maxDepth) {
                    list.addAll(((StructureTemplatePool)holder.m_203334_()).m_227362_(this.random));
                }
                list.addAll(((StructureTemplatePool)holder1.m_203334_()).m_227362_(this.random));
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurepoolelement1 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                    for (Rotation rotation1 : Rotation.m_221992_((RandomSource)this.random)) {
                        List list1 = structurepoolelement1.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, rotation1, this.random);
                        BoundingBox boundingbox1 = structurepoolelement1.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, rotation1);
                        int l = p_227268_ && boundingbox1.m_71057_() <= 16 ? list1.stream().mapToInt(p_255598_ -> {
                            if (!boundingbox1.m_71051_((Vec3i)p_255598_.f_74675_().m_121945_(JigsawBlock.m_54250_((BlockState)p_255598_.f_74676_())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> resourcekey1 = Placer.readPoolName(p_255598_);
                            Optional optional1 = this.pools.m_203636_(resourcekey1);
                            Optional<Holder> optional2 = optional1.map(p_255600_ -> ((StructureTemplatePool)p_255600_.m_203334_()).m_254935_());
                            int j3 = optional1.map(p_255596_ -> ((StructureTemplatePool)p_255596_.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            int k3 = optional2.map(p_255601_ -> ((StructureTemplatePool)p_255601_.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            return Math.max(j3, k3);
                        }).max().orElse(0) : 0;
                        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo1 : list1) {
                            int l2;
                            int l1;
                            if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo, (StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo1)) continue;
                            BlockPos blockpos3 = structuretemplate$structureblockinfo1.f_74675_();
                            BlockPos blockpos4 = blockpos2.m_121996_((Vec3i)blockpos3);
                            BoundingBox boundingbox2 = structurepoolelement1.m_214015_(this.structureTemplateManager, blockpos4, rotation1);
                            int i1 = boundingbox2.m_162396_();
                            StructureTemplatePool.Projection structuretemplatepool$projection1 = structurepoolelement1.m_210539_();
                            boolean flag2 = structuretemplatepool$projection1 == StructureTemplatePool.Projection.RIGID;
                            int j1 = blockpos3.m_123342_();
                            int k1 = j - j1 + JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_()).m_122430_();
                            if (flag && flag2) {
                                l1 = i + k1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.m_223221_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                l1 = k - j1;
                            }
                            int i2 = l1 - i1;
                            BoundingBox boundingbox3 = boundingbox2.m_71045_(0, i2, 0);
                            BlockPos blockpos5 = blockpos4.m_7918_(0, i2, 0);
                            if (l > 0) {
                                int j2 = Math.max(l + 1, boundingbox3.m_162400_() - boundingbox3.m_162396_());
                                boundingbox3.m_162371_(new BlockPos(boundingbox3.m_162395_(), boundingbox3.m_162396_() + j2, boundingbox3.m_162398_()));
                            }
                            if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                            mutableobject1.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3)), (BooleanOp)BooleanOp.f_82685_));
                            int i3 = p_227265_.m_72647_();
                            int k2 = flag2 ? i3 - k1 : structurepoolelement1.m_210540_();
                            PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(this.structureTemplateManager, structurepoolelement1, blockpos5, k2, rotation1, boundingbox3);
                            if (flag) {
                                l2 = i + j;
                            } else if (flag2) {
                                l2 = l1 + j1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.m_223221_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                l2 = k + k1 / 2;
                            }
                            p_227265_.m_209916_(new JigsawJunction(blockpos2.m_123341_(), l2 - j + i3, blockpos2.m_123343_(), k1, structuretemplatepool$projection1));
                            poolelementstructurepiece.m_209916_(new JigsawJunction(blockpos1.m_123341_(), l2 - j1 + k2, blockpos1.m_123343_(), -k1, structuretemplatepool$projection));
                            this.pieces.add((PoolElementStructurePiece)poolelementstructurepiece);
                            if (p_227267_ + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new PieceState(poolelementstructurepiece, mutableobject1, p_227267_ + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolName(StructureTemplate.StructureBlockInfo p_256491_) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation(p_256491_.f_74677_().m_128461_("pool")));
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece p_210311_, MutableObject<VoxelShape> p_210312_, int p_210313_) {
            this.piece = p_210311_;
            this.free = p_210312_;
            this.depth = p_210313_;
        }
    }
}

