/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.PacketHandler;
import de.maxanier.guideapi.network.PacketSyncCategory;
import de.maxanier.guideapi.wrapper.EntryWrapper;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CategoryScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public HashMultimap<Integer, EntryWrapper> entryWrapperMap = HashMultimap.create();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int entryPage;
    @Nullable
    public EntryAbstract startEntry;

    public CategoryScreen(Book book, CategoryAbstract category, Player player, ItemStack bookStack, @Nullable EntryAbstract startEntry) {
        super(category.name, player, bookStack);
        this.book = book;
        this.category = category;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.entryPage = 0;
        this.startEntry = startEntry;
    }

    public void m_7856_() {
        this.entryWrapperMap.clear();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.buttonBack = new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.f_96541_.m_91152_((Screen)new HomeScreen(this.book, this.player, this.bookStack)), this);
        this.m_142416_((GuiEventListener)this.buttonBack);
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
                this.nextPage();
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.entryPage > 0) {
                this.prevPage();
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.f_96541_.m_91152_((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.m_142416_((GuiEventListener)this.buttonSearch);
        int eX = this.guiLeft + 37;
        int eY = this.guiTop + 15;
        int i = 0;
        int pageNumber = 0;
        ArrayList entries = Lists.newArrayList(this.category.entries.values());
        for (EntryAbstract entry : entries) {
            entry.onInit(this.book, this.category, this, this.player, this.bookStack);
            this.entryWrapperMap.put((Object)pageNumber, (Object)new EntryWrapper(this, this.book, this.category, entry, eX, eY, 4 * this.xSize / 6, 10, this.player, this.f_96547_, this.bookStack));
            if (entry.equals(this.startEntry)) {
                this.startEntry = null;
                this.entryPage = pageNumber;
            }
            eY += 13;
            if (++i < 11) continue;
            i = 0;
            eY = this.guiTop + 15;
            ++pageNumber;
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.f_96541_.f_91066_.f_92095_.getKey().m_84873_()) {
            this.f_96541_.m_91152_((Screen)new HomeScreen(this.book, this.player, this.bookStack));
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.entryPage > 0) {
            this.prevPage();
            return true;
        }
        return super.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int typeofClick) {
        boolean ret = super.m_6375_(mouseX, mouseY, typeofClick);
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            if (typeofClick == 0) {
                wrapper.entry.onLeftClicked(this.book, this.category, mouseX, mouseY, this.player, this);
                continue;
            }
            if (typeofClick != 1) continue;
            wrapper.entry.onRightClicked(this.book, this.category, mouseX, mouseY, this.player, this);
        }
        if (typeofClick == 1) {
            this.f_96541_.m_91152_((Screen)new HomeScreen(this.book, this.player, this.bookStack));
        }
        return ret;
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void nextPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty()) {
            ++this.entryPage;
        }
    }

    public void m_7379_() {
        super.m_7379_();
        PacketHandler.INSTANCE.sendToServer((Object)new PacketSyncCategory(this.book.getCategoryList().indexOf(this.category), this.entryPage));
    }

    public void prevPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != 0) {
            --this.entryPage;
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float renderPartialTicks) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.m_280218_(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        this.entryPage = Mth.m_14045_((int)this.entryPage, (int)0, (int)(this.entryWrapperMap.size() - 1));
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (wrapper.canPlayerSee()) {
                wrapper.draw(graphics, Minecraft.m_91087_().f_91073_.m_9598_(), mouseX, mouseY, this);
                wrapper.drawExtras(graphics, mouseX, mouseY, this);
            }
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            wrapper.onHoverOver(mouseX, mouseY);
        }
        this.drawCenteredStringWithoutShadow(graphics, this.f_96547_, String.format("%d/%d", this.entryPage + 1, this.entryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        graphics.m_280653_(this.f_96547_, this.category.getName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.f_93624_ = this.entryPage != 0;
        this.buttonNext.f_93624_ = this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty();
        super.m_88315_(graphics, mouseX, mouseY, renderPartialTicks);
    }
}

