/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.api.util.TextHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.brewing.BrewingRecipe;

public class PageBrewingRecipe
extends Page {
    private final IngredientCycler cycler = new IngredientCycler();
    public BrewingRecipe recipe;
    public Ingredient ingredient;
    public Ingredient input;
    public ItemStack output;

    public PageBrewingRecipe(BrewingRecipe recipe) {
        this.recipe = recipe;
        this.ingredient = recipe.getIngredient();
        this.input = recipe.getInput();
        this.output = recipe.getOutput();
    }

    public PageBrewingRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        this.input = input;
        this.output = output;
        this.ingredient = ingredient;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        this.cycler.tick(guiBase.getMinecraft());
        int xStart = guiLeft + 88;
        int yStart = guiTop + 52;
        SubTexture.POTION_GRID.draw(graphics, xStart, yStart);
        ArrayList<Component> badTip = new ArrayList<Component>();
        badTip.add((Component)Component.m_237115_((String)"guideapi.text.brewing.error"));
        guiBase.drawCenteredStringWithoutShadow(graphics, fontRendererObj, TextHelper.localizeEffect("guideapi.text.brewing.brew", new Object[0]), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        int x = xStart + 25;
        int y = yStart + 1;
        int finalX = x;
        int finalY = y;
        this.cycler.getCycledIngredientStack(this.ingredient, 0).ifPresent(s -> GuiHelper.drawItemStack(graphics, s, finalX, finalY));
        List<Component> tooltip = null;
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.ingredient.m_43908_()[0]);
        }
        GuiHelper.drawItemStack(graphics, this.input.m_43908_()[0], x, y += 39);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.input.m_43908_()[0]);
        }
        int hSpacing = 24;
        GuiHelper.drawItemStack(graphics, this.input.m_43908_()[0], x -= hSpacing, y -= 8);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.input.m_43908_()[0]);
        }
        GuiHelper.drawItemStack(graphics, this.input.m_43908_()[0], x += hSpacing * 2, y);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.input.m_43908_()[0]);
        }
        if (this.output.m_41619_()) {
            this.output = new ItemStack((ItemLike)Blocks.f_50375_);
        }
        x = xStart + 25;
        GuiHelper.drawItemStack(graphics, this.output, x, y += 31);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            List<Component> list = tooltip = this.output.m_41720_() == Item.m_41439_((Block)Blocks.f_50375_) ? badTip : GuiHelper.getTooltip(this.output);
        }
        if (this.output.m_41720_() == Item.m_41439_((Block)Blocks.f_50375_)) {
            guiBase.drawCenteredStringWithoutShadow(graphics, fontRendererObj, TextHelper.localizeEffect("guideapi.text.brewing.error", new Object[0]), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6, 15533885);
        }
        if (tooltip != null) {
            graphics.m_280666_(fontRendererObj, tooltip, mouseX, mouseY);
        }
    }
}

