/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.FermenterShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FermenterLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_POS = new BlockPos(2, 1, 2);
    private static final MultiblockFace FLUID_OUTPUT = new MultiblockFace(3, 0, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition FLUID_OUTPUT_CAP = CapabilityPosition.opposing(FLUID_OUTPUT);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    public static final int TANK_CAPACITY = 24000;
    public static final int ENERGY_CAPACITY = 16000;
    public static final int NUM_INPUT_SLOTS = 8;
    public static final int OUTPUT_SLOT = 8;
    public static final int EMPTY_FLUID_SLOT = 9;
    public static final int FILLED_FLUID_SLOT = 10;
    public static final int NUM_SLOTS = 11;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean rsEnabled = state.rsState.isEnabled(context);
        boolean wasActive = state.active;
        state.active = state.processor.tickServer(state, context.getLevel(), rsEnabled);
        if (wasActive != state.active) {
            context.requestMasterBESync();
        }
        if (!rsEnabled) {
            return;
        }
        boolean changed = false;
        if (state.energy.getEnergyStored() > 0 && state.processor.getQueueSize() < state.processor.getMaxQueueSize()) {
            changed = this.enqueueNewProcesses(context);
        }
        changed |= FluidUtils.multiblockFluidOutput(state.fluidOutput, state.tank, 9, 10, state.inventory);
        if (changed |= this.outputItem(context)) {
            context.markMasterDirty();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.active, context.isValid(), soundPos, IESounds.fermenter, 0.25f);
        }
    }

    private boolean enqueueNewProcesses(IMultiblockContext<State> ctx) {
        int n;
        State state = ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        boolean addedAny = false;
        int[] usedInvSlots = new int[8];
        for (MultiblockProcess<FermenterRecipe, ProcessContext.ProcessContextInMachine<FermenterRecipe>> process : state.processor.getQueue()) {
            if (!(process instanceof MultiblockProcessInMachine)) continue;
            int[] nArray = ((MultiblockProcessInMachine)process).getInputSlots();
            n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                int n2 = i2 = nArray[i];
                usedInvSlots[n2] = usedInvSlots[n2] + 1;
            }
        }
        Integer[] preferredSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
        Arrays.sort(preferredSlots, 0, 8, Comparator.comparingInt(arg0 -> usedInvSlots[arg0]));
        Integer[] integerArray = preferredSlots;
        int n3 = integerArray.length;
        for (n = 0; n < n3; ++n) {
            MultiblockProcessInMachine<FermenterRecipe> process;
            FermenterRecipe recipe;
            int slot = integerArray[n];
            ItemStack stack = state.inventory.getStackInSlot(slot);
            if (!stack.m_41619_()) {
                stack = stack.m_41777_();
                stack.m_41774_(usedInvSlots[slot]);
            }
            if (stack.m_41619_() || stack.m_41613_() <= 0 || (recipe = FermenterRecipe.findRecipe(level, stack)) == null || !state.processor.addProcessToQueue(process = new MultiblockProcessInMachine<FermenterRecipe>(recipe, slot), level, false)) continue;
            addedAny = true;
        }
        return addedAny;
    }

    private boolean outputItem(IMultiblockContext<State> ctx) {
        State state = ctx.getState();
        ItemStack outputStack = state.inventory.getStackInSlot(8);
        if (outputStack.m_41619_() || !ctx.getLevel().shouldTickModulo(8)) {
            return false;
        }
        IItemHandler outputHandler = state.itemOutput.getNullable();
        if (outputHandler == null) {
            return false;
        }
        ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)outputStack, (int)1);
        if ((stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).m_41619_()) {
            outputStack.m_41774_(1);
            return true;
        }
        return false;
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ENERGY && ENERGY_POS.equalsOrNullFace(position)) {
            return ctx.getState().energyHandler.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && FLUID_OUTPUT_CAP.equalsOrNullFace(position)) {
            return ctx.getState().fluidHandler.cast(ctx);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (new BlockPos(0, 1, 0).equals((Object)position.posInMultiblock())) {
                return ctx.getState().insertionHandler.cast(ctx);
            }
            if (new BlockPos(1, 1, 1).equals((Object)position.posInMultiblock())) {
                return ctx.getState().extractionHandler.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return FermenterShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(ComparatorManager.SimpleComparatorValue.inventory(State::getInventory, 0, 8), REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<FermenterRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        private final FluidTank tank = new FluidTank(24000);
        private final SlotwiseItemHandler inventory;
        private final MultiblockProcessor<FermenterRecipe, ProcessContext.ProcessContextInMachine<FermenterRecipe>> processor;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final CapabilityReference<IFluidHandler> fluidOutput;
        private final CapabilityReference<IItemHandler> itemOutput;
        private final StoredCapability<IItemHandler> insertionHandler;
        private final StoredCapability<IItemHandler> extractionHandler;
        private final StoredCapability<IFluidHandler> fluidHandler;
        private final StoredCapability<IEnergyStorage> energyHandler;
        public boolean active;
        private BooleanSupplier isPlayingSound = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            this.processor = new MultiblockProcessor(8, 0.0f, 8, ctx.getMarkDirtyRunnable(), FermenterRecipe.RECIPES::getById);
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.ANY_INPUT, 8), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.FLUID_INPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1)), ctx.getMarkDirtyRunnable());
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, FLUID_OUTPUT);
            this.itemOutput = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, new BlockPos(2, 1, 1), RelativeBlockFace.LEFT);
            this.insertionHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(0, 8)));
            this.extractionHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(8, 9)));
            this.fluidHandler = new StoredCapability<ArrayFluidHandler>(new ArrayFluidHandler((IFluidTank)this.tank, true, false, ctx.getMarkDirtyRunnable()));
            this.energyHandler = new StoredCapability<AveragingEnergyStorage>(this.energy);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public int[] getOutputSlots() {
            return new int[]{8};
        }

        @Override
        public int[] getOutputTanks() {
            return new int[]{0};
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tank};
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }

        public FluidTank getTank() {
            return this.tank;
        }
    }
}

