/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraftforge.common.ToolActions;

public abstract class ShieldCombatGoal<T extends AbstractIllager>
extends Goal {
    protected final T mob;
    protected final IntRange attackPhaseInterval;
    protected final IntRange attackInterval;
    protected int shieldCooldown = 0;
    protected ShieldCombatState combatState = ShieldCombatState.APPROACH;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    protected ShieldCombatGoal(T mob, float attackRadius, IntRange attackPhaseInterval, IntRange attackInterval) {
        this.mob = mob;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.attackPhaseInterval = attackPhaseInterval;
        this.attackInterval = attackInterval;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected boolean isHoldingShield() {
        return this.mob.m_21093_(is -> is.canPerformAction(ToolActions.SHIELD_BLOCK));
    }

    protected boolean hasTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    protected abstract boolean isHoldingWeapon();

    private boolean isEnemyNearby() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_20280_((Entity)this.mob.m_5448_()) < 128.0;
    }

    public boolean m_8036_() {
        return this.isHoldingShield() && this.isHoldingWeapon() && this.hasTarget();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.combatState = ShieldCombatState.APPROACH;
        this.attackTime = this.attackPhaseInterval.getValue(this.mob.m_217043_());
        this.shieldCooldown = 0;
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    protected boolean isUsingShield() {
        return this.mob.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK);
    }

    protected void startUsingShield() {
        if (this.shieldCooldown > 0) {
            return;
        }
        this.mob.m_6672_(this.mob.m_21205_().canPerformAction(ToolActions.SHIELD_BLOCK) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public void disableShield() {
        if (this.combatState == ShieldCombatState.STRAFE) {
            this.mob.m_5810_();
            this.shieldCooldown = 100;
            this.combatState = ShieldCombatState.SHIELD_COOLDOWN;
            this.mob.m_9236_().m_7605_(this.mob, (byte)30);
        }
    }

    abstract boolean performAttack();

    public void m_8037_() {
        float strafeSpeed;
        boolean hasBeenSeeing;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        double d0 = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean hasLineOfSight = this.mob.m_21574_().m_148306_((Entity)target);
        boolean bl = hasBeenSeeing = this.seeTime > 0;
        if (hasLineOfSight != hasBeenSeeing) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
            this.mob.m_21573_().m_26573_();
            ++this.strafingTime;
            if (this.combatState == ShieldCombatState.APPROACH) {
                this.combatState = ShieldCombatState.STRAFE;
                this.startUsingShield();
            }
        } else {
            this.mob.m_21573_().m_5624_((Entity)target, 1.0);
            this.strafingTime = -1;
            if (this.combatState == ShieldCombatState.STRAFE) {
                this.combatState = ShieldCombatState.APPROACH;
            }
        }
        float f = strafeSpeed = this.isUsingShield() ? 0.15f : 0.5f;
        if (this.strafingTime >= 20) {
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                this.strafingBackwards = false;
            } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.mob.m_21566_().m_24988_(this.strafingBackwards ? -strafeSpeed : strafeSpeed, this.strafingClockwise ? strafeSpeed : -strafeSpeed);
            this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.combatState == ShieldCombatState.SHIELD_COOLDOWN && --this.shieldCooldown <= 0) {
            this.combatState = ShieldCombatState.STRAFE;
            this.startUsingShield();
        }
        if (--this.attackTime <= 0 && this.seeTime >= -60) {
            switch (this.combatState) {
                case STRAFE: {
                    this.combatState = ShieldCombatState.ATTACK;
                    this.attackTime = this.attackInterval.getValue(this.mob.m_217043_());
                    this.mob.m_21253_();
                    break;
                }
                case ATTACK: {
                    if (!this.performAttack()) {
                        this.attackTime = this.attackInterval.getValue(this.mob.m_217043_());
                        break;
                    }
                    this.combatState = ShieldCombatState.STRAFE;
                    this.attackTime = this.attackPhaseInterval.getValue(this.mob.m_217043_());
                    this.startUsingShield();
                    break;
                }
            }
        }
    }

    static enum ShieldCombatState {
        APPROACH,
        STRAFE,
        ATTACK,
        SHIELD_COOLDOWN;

    }

    public record IntRange(int low, int high) {
        private int getValue(RandomSource rng) {
            return this.low + rng.m_188503_(this.high - this.low);
        }
    }
}

