/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class InternalStorageItem
extends IEBaseItem {
    public InternalStorageItem(Item.Properties props) {
        super(props);
    }

    public abstract int getSlotCount();

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new IEItemStackHandler(stack);
        }
        return null;
    }

    public void setContainedItems(ItemStack stack, NonNullList<ItemStack> inventory) {
        LazyOptional lazyHandler = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        lazyHandler.ifPresent(handler -> {
            if (handler instanceof IItemHandlerModifiable) {
                if (inventory.size() != handler.getSlots()) {
                    throw new IllegalArgumentException("Parameter inventory has " + inventory.size() + " slots, capability inventory has " + handler.getSlots());
                }
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ((IItemHandlerModifiable)handler).setStackInSlot(i, (ItemStack)inventory.get(i));
                }
            } else {
                IELogger.warn("No valid inventory handler found for " + stack);
            }
        });
    }

    public NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        LazyOptional lazyHandler = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        Optional ret = lazyHandler.map(handler -> {
            if (handler instanceof IEItemStackHandler) {
                return ((IEItemStackHandler)((Object)handler)).getContainedItems();
            }
            IELogger.warn("Inefficiently getting contained items. Why does " + stack + " have a non-IE IItemHandler?");
            NonNullList inv = NonNullList.m_122780_((int)handler.getSlots(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < handler.getSlots(); ++i) {
                inv.set(i, (Object)handler.getStackInSlot(i));
            }
            return inv;
        });
        return ret.orElse(NonNullList.m_122779_());
    }
}

