/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.command_wrapper;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.robertx22.library_of_exile.command_wrapper.ArgumentWrapper;
import com.robertx22.library_of_exile.command_wrapper.LiteralWrapper;
import com.robertx22.library_of_exile.command_wrapper.PermWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class CommandBuilder {
    public static List<CommandBuilder> ALL = new ArrayList<CommandBuilder>();
    List<ArgumentWrapper> args = new ArrayList<ArgumentWrapper>();
    List<LiteralWrapper> literals = new ArrayList<LiteralWrapper>();
    Consumer<CommandContext<CommandSourceStack>> action;
    String description;
    String start;
    private String commandString;

    public static void of(String startOrModid, CommandDispatcher dis, Consumer<CommandBuilder> c, String desc) {
        CommandBuilder b = new CommandBuilder();
        b.start = startOrModid;
        b.description = desc;
        c.accept(b);
        b.build((CommandDispatcher<CommandSourceStack>)dis);
        ALL.add(b);
    }

    public CommandBuilder addLiteral(String id, PermWrapper perm) {
        this.literals.add(new LiteralWrapper(id, perm));
        return this;
    }

    public CommandBuilder addArg(ArgumentWrapper arg) {
        this.args.add(arg);
        return this;
    }

    public CommandBuilder action(Consumer<CommandContext<CommandSourceStack>> ctx) {
        this.action = ctx;
        return this;
    }

    public void build(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder next;
        LiteralArgumentBuilder first = Commands.m_82127_((String)this.start);
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        ArrayList<LiteralArgumentBuilder> list = new ArrayList<LiteralArgumentBuilder>();
        list.add(first);
        int x = 0;
        for (LiteralWrapper literal : this.literals) {
            next = (LiteralArgumentBuilder)Commands.m_82127_((String)literal.id).requires(e -> e.m_6761_(literal.perm.perm));
            list.add(next);
            ++x;
        }
        for (ArgumentWrapper arg : this.args) {
            if (arg.isOptional()) {
                optionals.add(x);
            }
            next = arg.getType();
            if (arg.suggestions != null) {
                next.suggests(arg.suggestions);
            }
            list.add(next);
            ++x;
        }
        for (int i = list.size() - 1; i > 0; --i) {
            ArgumentBuilder v1 = (ArgumentBuilder)list.get(i);
            ArgumentBuilder v2 = (ArgumentBuilder)list.get(i - 1);
            if (optionals.contains(i) || i == list.size() - 1) {
                v1.executes(e -> {
                    this.action.accept((CommandContext<CommandSourceStack>)e);
                    return 0;
                });
            }
            v2.then(v1);
        }
        commandDispatcher.register(first);
        this.generateWikiString();
    }

    public String getWikiString() {
        Object s = this.commandString;
        s = (String)s + "\n" + this.description;
        return s;
    }

    private void generateWikiString() {
        String command = "/" + this.start;
        for (LiteralWrapper literal : this.literals) {
            command = command + " " + literal.id;
        }
        for (ArgumentWrapper arg : this.args) {
            command = command + " " + arg.argName;
        }
        this.commandString = command;
    }
}

