/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.config.map_dimension;

import com.robertx22.library_of_exile.config.map_dimension.ChunkProcessType;
import com.robertx22.library_of_exile.config.map_dimension.MapDimensionConfigDefaults;
import com.robertx22.library_of_exile.config.map_dimension.ProcessMapChunks;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.main.CommonInit;
import com.robertx22.library_of_exile.util.LazyClass;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class MapDimensionConfig {
    public ForgeConfigSpec.ConfigValue<String> ALLOWED_BLOCK_BREAK_TAG;
    public ForgeConfigSpec.ConfigValue<String> DISABLED_BLOCK_INTERACT_TAG;
    public ForgeConfigSpec.ConfigValue<String> BANNED_ITEMS_TAG;
    public ForgeConfigSpec.ConfigValue<String> ENVIRO_DMG_TAG;
    public ForgeConfigSpec.ConfigValue<String> DEFAULT_DATA_BLOCK;
    public ForgeConfigSpec.IntValue CHUNK_PROCESS_RADIUS;
    public ForgeConfigSpec.IntValue CHUNK_SPAWN_RADIUS;
    public ForgeConfigSpec.BooleanValue DESPAWN_INCORRECT_MOBS;
    public ForgeConfigSpec.BooleanValue DISABLE_WORLDBORDER_OVERRIDE;
    public ForgeConfigSpec.BooleanValue DIMENSION_MOBS_ENVIRO_IMMUNITY;
    public LazyClass<TagKey<Block>> LAZY_ALLOWED_BLOCKS = new LazyClass<TagKey>(() -> BlockTags.create((ResourceLocation)new ResourceLocation((String)this.ALLOWED_BLOCK_BREAK_TAG.get())));
    public LazyClass<TagKey<Block>> LAZY_BLOCKED_INTERACT_BLOCKS = new LazyClass<TagKey>(() -> BlockTags.create((ResourceLocation)new ResourceLocation((String)this.DISABLED_BLOCK_INTERACT_TAG.get())));
    public LazyClass<TagKey<Item>> LAZY_BANNED_ITEMS = new LazyClass<TagKey>(() -> ItemTags.create((ResourceLocation)new ResourceLocation((String)this.BANNED_ITEMS_TAG.get())));
    public LazyClass<TagKey<DamageType>> LAZY_ENVIRO_TAG = new LazyClass<TagKey>(() -> MapDimensionConfig.create(new ResourceLocation((String)this.ENVIRO_DMG_TAG.get())));

    MapDimensionConfig(ForgeConfigSpec.Builder b, MapDimensionConfigDefaults opt, String id) {
        b.comment("Map Dimension Config, Note: These configs are ONLY for this dimension!").push(id);
        this.DEFAULT_DATA_BLOCK = b.comment("Sometimes structures have old/wrong data blocks, instead of skipping them, we can instead use them to spawn a replacement.\nBy default, a small mob pack will spawn instead.\nAdvised to leave this as is").define("DEFAULT_DATA_BLOCK", (Object)"mob");
        this.ALLOWED_BLOCK_BREAK_TAG = b.comment("Blocks in this tag will be breakable. This config isn't meant to be edited! Edit the tag datapack instead!\nUse this for stuff like Grave mod blocks").define("ALLOWED_BLOCK_BREAK_TAG", (Object)"library_of_exile:map_allowed_block_break");
        this.DISABLED_BLOCK_INTERACT_TAG = b.comment("Blocks in this tag will NOT be interactable. This config isn't meant to be edited! Edit the tag datapack instead!\n As an example, by default dispensers can't be interacted with so players can't steal items from them.").define("DISABLED_BLOCK_INTERACT_TAG", (Object)"library_of_exile:map_disable_block_interact");
        this.BANNED_ITEMS_TAG = b.comment("Items in this Tag will be unusable with right click in this dimension. This config isn't meant to be edited! Edit the tag datapack instead!\n As an example, by default chorus fruit and other teleportation items are banned..").define("BANNED_ITEMS_TAG", (Object)"library_of_exile:banned_map_items");
        this.ENVIRO_DMG_TAG = b.comment("Damage Type tags for enviro damage. This is used to stop mobs in this dimension from being hurt by them\nThis only stops the damage if it's enviro dmg, meaning there's no entity/player as damage source").define("ENVIRO_DMG_TAG", (Object)"library_of_exile:enviro_damage");
        this.CHUNK_PROCESS_RADIUS = b.comment("The chunk radius in which map data blocks will be turned into map content while in maps. Depending on map type, different values can be good\nFor example Arena-type maps you probably want the number to be high so all the stuff generates right away\nBut for exploration-type big maps, you probably don't want mobs to spawn 5 chunks away and despawn\n0 Radius means only the chunk the player is currently in will be processed").defineInRange("CHUNK_PROCESS_RADIUS", opt.chunkProcessRadius, 0, 8);
        this.CHUNK_SPAWN_RADIUS = b.comment("Radius in which the data blocks will turn to actual content in map.").defineInRange("CHUNK_SPAWN_RADIUS", opt.chunkSpawnRadius, 0, 8);
        this.DESPAWN_INCORRECT_MOBS = b.comment("Despawns or tries to stop spawning of mobs that shouldn't spawn in the dimension").define("DESPAWN_INCORRECT_MOBS", true);
        this.DISABLE_WORLDBORDER_OVERRIDE = b.comment("By default this dimension has its worldborder overrided because these dimensions are meant to be infinite.\nIt's recommended to just wipe the dimension's save folder when needed instead as they're not meant to be built in anyway, so wiping them is no problem.\nThis config is only here in case this feature causes more urgent bugs.").define("DISABLE_WORLDBORDER_OVERRIDE", false);
        this.DIMENSION_MOBS_ENVIRO_IMMUNITY = b.comment("Makes mobs inside this dimension immune to enviromental damage.\nRecommended ON because otherwise a lot of dimension mobs will die to: wither roses, lava, water, wall damage etc.").define("DIMENSION_MOBS_ENVIRO_IMMUNITY", true);
        b.pop();
    }

    private static TagKey<DamageType> create(ResourceLocation pName) {
        return TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)pName);
    }

    static boolean isDimension(ResourceLocation id, Level level) {
        return level.m_220362_().m_135782_().equals((Object)id);
    }

    static boolean tryGiveLeeWay(Entity en) {
        Player p;
        return !(en instanceof Player) || !(p = (Player)en).m_7500_();
    }

    public static MapDimensionConfig register(MapDimensionInfo info, MapDimensionConfigDefaults opt) {
        ResourceLocation mapId = info.dimensionId;
        Pair specPair = new ForgeConfigSpec.Builder().configure(b -> new MapDimensionConfig((ForgeConfigSpec.Builder)b, opt, mapId.toString()));
        ForgeConfigSpec SPEC = (ForgeConfigSpec)specPair.getRight();
        MapDimensionConfig CONFIG = (MapDimensionConfig)specPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SPEC, CommonInit.defaultConfigName(ModConfig.Type.SERVER, mapId.m_135827_() + "_dimension"));
        ApiForgeEvents.registerForgeEvent(PlayerInteractEvent.RightClickItem.class, event -> {
            if (!MapDimensionConfig.isDimension(mapId, event.getEntity().m_9236_()) || !MapDimensions.isMap(event.getEntity().m_9236_())) {
                return;
            }
            if (event.getItemStack().m_204117_(CONFIG.LAZY_BANNED_ITEMS.get()) && MapDimensionConfig.tryGiveLeeWay((Entity)event.getEntity())) {
                if (!event.getLevel().f_46443_) {
                    event.getEntity().m_213846_((Component)Component.m_237113_((String)"Item is banned in This Dimension: ").m_7220_(event.getItemStack().m_41611_()).m_130940_(ChatFormatting.BOLD));
                }
                event.setCanceled(true);
            }
        });
        ApiForgeEvents.registerForgeEvent(BlockEvent.BreakEvent.class, event -> {
            try {
                if (!MapDimensionConfig.isDimension(mapId, event.getPlayer().m_9236_()) || !MapDimensions.isMap(event.getPlayer().m_9236_())) {
                    return;
                }
                if (!event.getState().m_204336_(CONFIG.LAZY_ALLOWED_BLOCKS.get()) && MapDimensionConfig.tryGiveLeeWay((Entity)event.getPlayer())) {
                    event.setCanceled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingDestroyBlockEvent.class, event -> {
            try {
                if (!MapDimensionConfig.isDimension(mapId, event.getEntity().m_9236_()) || !MapDimensions.isMap(event.getEntity().m_9236_())) {
                    return;
                }
                if (!event.getState().m_204336_(CONFIG.LAZY_ALLOWED_BLOCKS.get()) && MapDimensionConfig.tryGiveLeeWay((Entity)event.getEntity())) {
                    event.setCanceled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(BlockEvent.EntityPlaceEvent.class, event -> {
            try {
                Entity en = event.getEntity();
                if (!MapDimensionConfig.isDimension(mapId, event.getEntity().m_9236_()) || !MapDimensions.isMap(event.getEntity().m_9236_())) {
                    return;
                }
                if (MapDimensionConfig.tryGiveLeeWay(en)) {
                    event.setCanceled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(FillBucketEvent.class, event -> {
            try {
                Player p = event.getEntity();
                if (!MapDimensionConfig.isDimension(mapId, event.getEntity().m_9236_()) || !MapDimensions.isMap(event.getEntity().m_9236_())) {
                    return;
                }
                if (MapDimensionConfig.tryGiveLeeWay((Entity)p)) {
                    event.setCanceled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(ExplosionEvent.Detonate.class, event -> {
            try {
                if (!MapDimensionConfig.isDimension(mapId, event.getLevel()) || !MapDimensions.isMap(event.getLevel())) {
                    return;
                }
                event.getAffectedBlocks().clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(EntityMobGriefingEvent.class, event -> {
            try {
                if (!MapDimensionConfig.isDimension(mapId, event.getEntity().m_9236_()) || !MapDimensions.isMap(event.getEntity().m_9236_())) {
                    return;
                }
                event.setResult(Event.Result.DENY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(PlayerInteractEvent.RightClickBlock.class, event -> {
            try {
                Player p = event.getEntity();
                if (!MapDimensionConfig.isDimension(mapId, event.getEntity().m_9236_()) || !MapDimensions.isMap(event.getEntity().m_9236_())) {
                    return;
                }
                BlockState block = p.m_9236_().m_8055_(event.getPos());
                if (block.m_204336_(CONFIG.LAZY_BLOCKED_INTERACT_BLOCKS.get()) && MapDimensionConfig.tryGiveLeeWay((Entity)p)) {
                    event.setCanceled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(TickEvent.PlayerTickEvent.class, event -> {
            Player p = event.player;
            if (p.f_19797_ % 20 != 0) {
                return;
            }
            if (p.f_19797_ < 20) {
                return;
            }
            if (p.m_9236_().f_46443_ || event.phase != TickEvent.Phase.END) {
                return;
            }
            if (!MapDimensionConfig.isDimension(mapId, p.m_9236_()) || !MapDimensions.isMap(p.m_9236_())) {
                return;
            }
            ProcessMapChunks.process(p, info, CONFIG, ChunkProcessType.NORMAL);
        });
        List<MobSpawnType> blockedSpawnTypes = Arrays.asList(MobSpawnType.BREEDING, MobSpawnType.BUCKET, MobSpawnType.CHUNK_GENERATION, MobSpawnType.NATURAL, MobSpawnType.REINFORCEMENT);
        ApiForgeEvents.registerForgeEvent(MobSpawnEvent.SpawnPlacementCheck.class, event -> {
            try {
                ServerLevel world = event.getLevel().m_6018_();
                if (world.f_46443_) {
                    return;
                }
                if (!MapDimensionConfig.isDimension(mapId, (Level)world) || !MapDimensions.isMap((Level)world)) {
                    return;
                }
                if (((Boolean)CONFIG.DESPAWN_INCORRECT_MOBS.get()).booleanValue()) {
                    return;
                }
                if (event.getEntityType() == EntityType.f_20532_) {
                    return;
                }
                MobSpawnType type = event.getSpawnType();
                if (blockedSpawnTypes.contains(type)) {
                    event.setResult(Event.Result.DENY);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingAttackEvent.class, event -> {
            try {
                LivingEntity en = event.getEntity();
                if (!MapDimensionConfig.isDimension(mapId, event.getEntity().m_9236_()) || !MapDimensions.isMap(event.getEntity().m_9236_())) {
                    return;
                }
                if (en instanceof Player) {
                    return;
                }
                if (((Boolean)CONFIG.DIMENSION_MOBS_ENVIRO_IMMUNITY.get()).booleanValue() && !(event.getSource().m_7639_() instanceof LivingEntity) && event.getSource().m_269533_(CONFIG.LAZY_ENVIRO_TAG.get())) {
                    event.setCanceled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return CONFIG;
    }
}

