/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.database.init;

import com.robertx22.library_of_exile.database.init.PredeterminedRandomEvent;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.MapGenerationUTIL;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public interface PredeterminedResult<T> {
    public ExileRegistryType getRegistryType();

    public T getPredeterminedRandomINTERNAL(Random var1, Level var2, ChunkPos var3);

    default public T getPredeterminedRandom(Level level, BlockPos pos) {
        PredeterminedRandomEvent event = new PredeterminedRandomEvent(this.getRegistryType(), level, pos);
        ExileEvents.PREDETERMINED_RANDOM.callEvents(event);
        if (!event.result.isEmpty()) {
            if (!Database.getRegistry(this.getRegistryType()).isRegistered(event.result)) {
                throw new RuntimeException(event.result + " is not registered! Can't use it for predetermined outcome override");
            }
            return (T)Database.getRegistry(this.getRegistryType()).get(event.result);
        }
        ChunkPos start = MapDimensions.getInfo((Level)level).structure.getStartChunkPos(pos);
        Random random = MapGenerationUTIL.createRandom(start);
        return this.getPredeterminedRandomINTERNAL(random, level, start);
    }
}

