/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension;

import com.robertx22.library_of_exile.components.AllMapConnectionData;
import com.robertx22.library_of_exile.components.MapConnectionsCap;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class CurrentLeague {
    public MapDimensionInfo dimension;
    public Optional<MapStructure> structure;
    public Optional<AllMapConnectionData.Data> connectedFrom = Optional.empty();

    public CurrentLeague(MapDimensionInfo dimension, Optional<MapStructure> structure, Optional<AllMapConnectionData.Data> connectedFrom) {
        this.dimension = dimension;
        this.structure = structure;
        this.connectedFrom = connectedFrom;
    }

    public static Optional<CurrentLeague> get(ServerLevel level, BlockPos pos) {
        MapDimensionInfo info = MapDimensions.getInfo((Level)level);
        if (info != null) {
            if (info.isInside(info.structure, level, pos)) {
                return Optional.of(new CurrentLeague(info, Optional.of(info.structure), CurrentLeague.getConnectedMap(level, pos)));
            }
            Optional<MapStructure> opt = info.secondaryStructures.stream().filter(x -> info.isInside((MapStructure)x, level, pos)).findAny();
            if (opt.isPresent()) {
                return Optional.of(new CurrentLeague(info, Optional.of(opt.get()), CurrentLeague.getConnectedMap(level, pos)));
            }
            return Optional.of(new CurrentLeague(info, Optional.empty(), CurrentLeague.getConnectedMap(level, pos)));
        }
        return Optional.empty();
    }

    public boolean isAffectedBy(MapDimensionInfo info) {
        if (this.structure.isPresent() && info.hasStructure(this.structure.get())) {
            return true;
        }
        return info.hasStructure(this.dimension.structure);
    }

    public static Optional<AllMapConnectionData.Data> getConnectedMap(ServerLevel level, BlockPos pos) {
        AllMapConnectionData cons = MapConnectionsCap.get((Level)level).data;
        AllMapConnectionData.Data data = cons.getOriginalMap((Level)level, pos);
        return data == null ? Optional.empty() : Optional.of(data);
    }
}

