/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension;

import com.robertx22.library_of_exile.config.map_dimension.MapDimensionConfig;
import com.robertx22.library_of_exile.config.map_dimension.MapDimensionConfigDefaults;
import com.robertx22.library_of_exile.dimension.MapContentType;
import com.robertx22.library_of_exile.dimension.MobValidator;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;

public class MapDimensionInfo {
    public ResourceLocation dimensionId;
    public MapStructure<?> structure;
    public MapContentType contentType = MapContentType.SIDE_CONTENT;
    public List<MapStructure<?>> secondaryStructures = new ArrayList();
    public MapDimensionConfig config;
    public MobValidator mobValidator = new MobValidator(){

        @Override
        public boolean isValidMob(LivingEntity en) {
            return true;
        }
    };

    public MapDimensionInfo(ResourceLocation dimensionId, MapStructure<?> structure, MapContentType contentType, List<MapStructure<?>> secondaryStructures, MobValidator mobValidator, MapDimensionConfigDefaults def) {
        this.dimensionId = dimensionId;
        this.structure = structure;
        this.contentType = contentType;
        this.secondaryStructures = secondaryStructures;
        this.mobValidator = mobValidator;
        this.config = MapDimensionConfig.register(this, def);
    }

    public boolean isInside(MapStructure struc, ServerLevel level, BlockPos pos) {
        if (!level.m_46472_().m_135782_().equals((Object)this.dimensionId)) {
            return false;
        }
        return struc.isInside(level, pos);
    }

    public boolean hasStructure(MapStructure struc) {
        if (struc.guid().equals(this.structure.guid())) {
            return true;
        }
        return this.secondaryStructures.stream().anyMatch(x -> x.guid().equals(struc.guid()));
    }
}

