/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension;

import com.robertx22.library_of_exile.main.ExileLog;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MapGenerationUTIL {
    public static Random createRandom(Level level, ChunkPos start) {
        long worldSeed = level.m_7654_().m_129910_().m_246337_().m_245499_();
        int chunkX = start.f_45578_;
        int chunkZ = start.f_45579_;
        long newSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ worldSeed;
        return new Random(newSeed);
    }

    public static Random createRandom(ChunkPos start) {
        return MapGenerationUTIL.createRandom((Level)ServerLifecycleHooks.getCurrentServer().m_129783_(), start);
    }

    public static boolean spawnStructure(ServerLevelAccessor level, ChunkPos cpos, StructureTemplateManager man, int y, ResourceLocation room, boolean errorIfMissing) {
        try {
            BlockPos position;
            StructurePlaceSettings settings;
            StructureTemplate template;
            Optional opt = man.m_230407_(room);
            if (opt.isPresent()) {
                template = (StructureTemplate)opt.get();
                settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74392_(false);
                settings.m_74381_(settings.m_74409_());
                position = cpos.m_151384_(0, y, 0);
                if (template == null) {
                    if (errorIfMissing) {
                        ExileLog.get().warn("FATAL ERROR: Structure does not exist (" + room.toString() + ")", new Object[0]);
                    }
                    return false;
                }
                if (template.m_163801_().m_123341_() > 16 || template.m_163801_().m_123343_() > 16) {
                    ExileLog.get().warn("FATAL ERROR: Structure is bigger than possible (" + room + ") " + template.m_163801_().toString(), new Object[0]);
                    return false;
                }
            } else {
                if (errorIfMissing) {
                    ExileLog.get().warn("FATAL ERROR: Structure does not exist (" + room.toString() + ")", new Object[0]);
                }
                return false;
            }
            settings.m_74379_(Rotation.NONE);
            template.m_230328_(level, position, position, settings, level.m_213780_(), 18);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

