/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension.worlddata;

import com.robertx22.library_of_exile.components.AllMapConnectionData;
import com.robertx22.library_of_exile.components.MapConnectionsCap;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class MapPlayerDataSaver<T> {
    private HashMap<String, T> map = new HashMap();
    private HashMap<String, String> playerMapIdMap = new HashMap();

    public T getData(Player p) {
        String id = p.m_20149_();
        return this.map.get(id);
    }

    public T getData(MapStructure structure, BlockPos pos) {
        ChunkPos start = structure.getStartChunkPos(new ChunkPos(pos));
        String key = this.getKey(start);
        return this.map.get(key);
    }

    public boolean hasData(Player p) {
        return this.map.containsKey(p.m_20149_());
    }

    public boolean hasData(MapStructure structure, BlockPos pos) {
        ChunkPos start = structure.getStartChunkPos(new ChunkPos(pos));
        String key = this.getKey(start);
        return this.map.containsKey(key);
    }

    public void setData(Player p, T data, MapStructure structure, BlockPos pos) {
        if (this.playerMapIdMap.containsKey(p.m_20149_())) {
            this.map.remove(this.playerMapIdMap.get(p.m_20149_()));
        }
        ChunkPos start = structure.getStartChunkPos(new ChunkPos(pos));
        String key = this.getKey(start);
        this.map.put(key, data);
        this.playerMapIdMap.put(p.m_20149_(), key);
        AllMapConnectionData cons = MapConnectionsCap.get((Level)p.m_9236_()).data;
        MapDimensionInfo origin = MapDimensions.getInfo(p.m_9236_());
        if (origin != null) {
            MapDimensionInfo side = MapDimensions.getInfo(structure);
            cons.tryCreateConnection(origin, p.m_20183_(), side, pos);
        }
    }

    public String getKey(ChunkPos cp) {
        return cp.f_45578_ + "_" + cp.f_45579_;
    }
}

