/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension;

import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.main.ExileLog;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public class WipeDimensionFeature {
    public static void OnStartResetMap(MapDimensionInfo map, ResourceLocation mapid) {
        File file = new File(FMLPaths.GAMEDIR.get().toAbsolutePath().toString());
        Collection list = FileUtils.listFilesAndDirs((File)file, (IOFileFilter)new Dir(), (IOFileFilter)new Dir());
        for (File dir : list) {
            try {
                if (!WipeDimensionFeature.dirMatches(dir, mapid)) continue;
                WipeDimensionFeature.deleteDirectoryRecursion(dir.toPath());
                map.markDataForClear = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean dirMatches(File file, ResourceLocation mapid) {
        String check;
        String str;
        if (file.isDirectory() && (str = file.toPath().toString()).endsWith(check = "dimensions" + File.separator + mapid.m_135827_() + File.separator + mapid.m_135815_())) {
            ExileLog.get().log("Wiping dimension folder: " + file.toString() + " - If this is a " + mapid.toString() + " dimension folder, then the feature is working correctly. Report if it tries deleting something else though!", new Object[0]);
            ExileLog.get().log("These dimensions are meant to be wiped on server boot to remain infinite.", new Object[0]);
            return true;
        }
        return false;
    }

    static void deleteDirectoryRecursion(Path path) throws IOException {
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
                for (Path entry : entries) {
                    WipeDimensionFeature.deleteDirectoryRecursion(entry);
                }
            }
        }
        Files.delete(path);
    }

    static class Dir
    implements IOFileFilter {
        Dir() {
        }

        public boolean accept(File file) {
            return file != null && file.isDirectory();
        }

        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

